/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef __IKERNEL_H__
#define __IKERNEL_H__


namespace Martini { namespace Infrastructure
{
    class IKernel  
    {
    public:
        virtual TResult InstantiateClient(MPI::TId clientId, 
                                          const char *szRequestedModuleName,
                                          const char *szOptions) = 0;
        virtual SClientInfo *GetClientInfo(MPI::TId id) = 0;
        virtual SClientInfo *GetClientInfo(const char* szProfiler) = 0;
        virtual TResult Configure(MPI::BitSet configuration) = 0;
        virtual TResult SuspendVM() = 0;
        virtual TResult ResumeVM() = 0;
        virtual TResult RunGC() = 0;
        virtual TResult GenerateObjectAllocEventForLiveObjects(MPI::TId clientId) = 0;
    };

}}

#endif 


