/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef __ILOGASSERT_H__
#define __ILOGASSERT_H__

namespace Martini { namespace Infrastructure
{

    /**
     * @brief A utility interface for using the singleton Logger instance
     */
    class ILogAssert : public MPI::IEcSetOutputDirEventObserver
    {
    public:
        /**
         * @brief Sends an error message to the logger.
         *
         * This function writes an error message to the logger. If an External Control module
         * is loaded, the message will be passed to it and it is expected that the External
         * Control module will terminate the application.
         * 
         * @param[in] szClient      client/module name
         * @param[in] szFormatMsg   format string
         * @param[in] ...           message arguments. Must match the format string.
         */
        virtual void Error(const char* szClient, const char* szFormatMsg, ...) = 0;

        /**
         * @brief Sends an informative message to the logger.
         *
         * @param[in] szClient      client/module name
         * @param[in] iLevel        message level. The message will be written to the log
         *                          file if iLevel >= logger configured level (default is 3).
         * @param[in] bExposeToEC   if true, the message will be sent to the External Control
         *                          module (if one is loaded).
         * @param[in] szFormatMsg   format string
         * @param[in] ...           message arguments. Must match the format string.
         */
        virtual void Informative(const char* szClient, int iLevel, bool bExposeToEC, 
            const char* szFormatMsg, ...) = 0;

        /**
         * @brief Sends a debug message to the logger.
         *
         * @param[in] szClient      client/module name
         * @param[in] iLevel        message level. The message will be written to the log
         *                          file if iLevel >= logger configured level (default is 3).
         * @param[in] szFormatMsg   format string
         * @param[in] ...           message arguments. Must match the format string.
         */
        virtual void Debug(const char* szClient, int iLevel, const char* szFormatMsg, ...) = 0;
    };
    
}} 


#endif 
 


