/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef MRTE_ID_ALLOCATOR
#define MRTE_ID_ALLOCATOR

#include "OSA.h"

namespace Martini { namespace Infrastructure
{
    class CIdAllocator  
    {
    public:
        CIdAllocator();
        CIdAllocator(unsigned int uiFirstId);
        virtual ~CIdAllocator();
        unsigned int AllocateId();

        // allocate several ids in a continuous order
        unsigned int AllocateIds(unsigned int uiNumIds);
    private:
        Martini::OSA::IThreadSync *m_pThreadSync;
        unsigned int m_uiNextId;
    };
}}
#endif 


