/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef _MRTE_JPI_H
#define _MRTE_JPI_H

#include <iostream>
#include "OSA.h"
#include "jvmti.h"
#include "MPI.h"

#ifdef JPI_EXPORTS
#define JPI_API API_EXPORT
//#define JPI_API __declspec(dllexport)
#else
#define JPI_API API_IMPORT 
//#define JPI_API __declspec(dllimport)
#endif

namespace Martini { namespace JPI {

    class CJpiInterface : public MPI::CMpiInterface
    {
    public:
        CJpiInterface(MPI::ERuntimeType iRuntimeType, Infrastructure::IDataManager *pDataManager, 
                Infrastructure::IEventManager *pEventManager, Infrastructure::IKernel *pKernel, 
                Infrastructure::CECAgent* pECAgent, Infrastructure::CLogger* pLogger);

        virtual ~CJpiInterface() {}

        // IMPI methods

        virtual MIE::IMIE* GetInstrumentor();

    private:
        
        // Disable default constructor
        CJpiInterface() {}
    };
}};

#define JPI_WARNING(warning, param) /*(std::cout << "JPI WARNING:" << warning << param << std::endl)*/  

#ifdef __cplusplus
extern "C" {
#endif

enum EJVMInterfaceType
{
    TYPE_JVMPI,
    TYPE_JVMTI,
};


//
// JPI Initialization function
//
typedef int (*TJpiInitialize) (JavaVM *pInterface, 
                               char *szOptions, 
                               EJVMInterfaceType jvmInterfaceType);
JPI_API int JPI_Initialize(JavaVM *pVm, char *szOptions, EJVMInterfaceType jvmInterfaceType);

//
// Helper functions for "special" Martini clients (e.g., Eclipse TPTP Probekit)
//

typedef TResult (*TJpiAttachCurrentThread) (JNIEnv **ppJNIEnv, bool *bAttached);
JPI_API TResult JPI_AttachCurrentThread(JNIEnv **ppJNIEnv, bool *bAttached);

typedef void (*TJpiDetachCurrentThread) ();
JPI_API void JPI_DetachCurrentThread();

#ifdef __cplusplus
}
#endif

#endif


