/*****************************************************************************
 * Copyright (c) 1997, 2009, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef __LOGGER_H__
#define __LOGGER_H__

#include "MpiAPI.h"
#include "MList.h"
#include <stdio.h>
#include "OSA.h"

namespace Martini { namespace Infrastructure
{

    enum ELogConfigField
    {
        LCF_NONE                    = 0x0000,
        LCF_REPLACE_FILE_IF_EXIST   = 0x0001,
        LCF_FORCE_LOG_LEVEL         = 0x0002,
        LCF_OUTPUT_TO_STDERR        = 0x0004,
        LCF_HEADER_PID              = 0x0010,
        LCF_HEADER_COMMAND_LINE     = 0x0020,
        LCF_HEADER_MACHINE_NAME     = 0x0040,
        LCF_HEADER_ALL              = 0x0070,
        LCF_LINE_TID                = 0x0080,
        LCF_LINE_DATE               = 0x0100,
        LCF_LINE_TIME               = 0x0200,
        LCF_LINE_CLIENT_NAME        = 0x0400,
        LCF_LINE_LOG_TYPE           = 0x0800,
        LCF_LINE_LOG_LEVEL          = 0x1000,
        LCF_LINE_ALL                = 0x1F80,
    };

    class CLogger  
    {
    public:
        CLogger();
        virtual ~CLogger();

        TResult Configure(unsigned int configField, const char* szFileName, int iLevel);
            
        void Log(const char* szClientName, MPI::EMessageType msgType, const char* szMsg, 
            int iLevel = 0);
        void Log(const char* szClientName, MPI::EMessageType msgType, const wchar_t* wszMsg, 
            int iLevel = 0);

        TResult StartBufferMode();
        TResult EndBufferMode();

    private:
        TResult CreateLogFile(unsigned int configField, const char* szFileName);
        void WriteToFile(FILE * m_hFile, char * text);

        RTUtil::MList<char*>* m_pMessageBuffer;
        OSA::IThreadSync* m_csLogLine;

        FILE* m_hFile;
        char* m_szFileName;

        unsigned int m_uiLineConfig;
        int m_iLevel;
        bool m_bForceLogLevel;
        bool m_bOutputToStderr;
    };

}}

#endif 

