/*****************************************************************************
 * Copyright (c) 1997, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef _MRTE_MPI_IMPL_H
#define _MRTE_MPI_IMPL_H

#pragma warning(disable:4786)

#include "MpiAPI.h"
#include "IDataManager.h"
#include "IEventManager.h"
#include "IKernel.h"
#include "Logger.h"


namespace Martini { 

namespace Infrastructure
{
    class CECAgent;
}

namespace MPI
{
    class CMpiInterface : public IMpi
    {
    public:
        CMpiInterface(ERuntimeType iRuntimeType, Infrastructure::IDataManager *pDataManager, 
                Infrastructure::IEventManager *pEventManager, Infrastructure::IKernel *pKernel, 
                Infrastructure::CECAgent* pECAgent, Infrastructure::CLogger* pLogger);

        virtual ~CMpiInterface();

        // IMpi methods

        virtual TResult RegisterEvent(TId clientId,
                                      IEventObserver &observer);
        
        virtual TResult SetEventGroupFilter(TId clientID, 
                                            EEventGroup group,
                                            IEventFilter &filter);


        virtual TResult EnableEventGroup(TId clientId, EEventGroup eventGroup);

        virtual TResult DisableEventGroup(TId clientId, EEventGroup eventGroup);
      
        virtual TResult GetModuleInfo(TId clientId,
                                      TId moduleId,
                                      BitSet requestedDataTypes, 
                                      SModuleInfo *pData);

        virtual TResult GetClassInfo(TId clientId,
                                     TId classId,
                                     BitSet requestedDataTypes, 
                                     SClassInfo *pData);

        virtual TResult GetMethodInfo(TId clientId,
                                      TId methodId,
                                      BitSet requestedDataTypes, 
                                      SMethodInfo *pData);

        virtual TResult GetCompiledMethodInfo(TId clientId,
                                              const char* szModuleName,
                                              UIOP uiIpOffset,
                                              BitSet requestedDataTypes,
                                              TId *pMethodId,
                                              SMethodInfo *pData);

        virtual TResult GetObjectInfo(TId clientId,
                                      TId objectId,
                                      BitSet requestedDataTypes,
                                      SObjectDataRequest *pData);

        virtual TResult GetThreadInfo(TId clientId,
                                      TId threadId,
                                      BitSet requestedDataTypes, 
                                      SThreadInfo *pData,
                                      TDotNetUnmanagedStackWalkCallBack pUnManagedStackWalker);
        
        virtual TResult GetAllThreadsInfo(TId clientId, 
                                          U32 maxFrameCount, 
                                          BitSet requestedDataTypes, 
                                          SThreadInfoArray *pData);

        virtual ERuntimeType GetRuntimeType() { return m_iRuntimeType; }
    
        virtual TResult InstantiateClient(TId clientId, 
                                          const char *szRequestedModuleName,
                                          const char *szOptions);

        virtual MIE::IMIE* GetInstrumentor() = 0;

        virtual TResult IsInheritedFrom(const char *szClass, const char *szBaseClass)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }; 
        

        virtual TResult Configure(BitSet configuration, SConfigData *pConfigData)
        {
			return (m_pKernel->Configure(configuration));
        }

        virtual TResult MessageLog(TId clientId, EMessageType msgType, BitSet msgDest, 
                                   char* szMessage, unsigned int iLevel = 0);

        virtual void GetVersion(SVersionInfo *pVersionInfo)
        {
            pVersionInfo->major = 2;
            pVersionInfo->minor = 0;
        }

        virtual TResult GetObjectReferences(TId clientId, SObjectReferenceInfo *pData);

        virtual TResult SuspendVM();

        virtual TResult ResumeVM();

        virtual TResult RunGC();

        virtual TResult RunHeapObjDataCollection(THeapObjectAnalysis *TId);

        virtual void SetHeapObjDataCollection(bool heapObjDataCollection);

        virtual TResult GenerateObjectAllocEventForLiveObjects(TId clientId);

	protected:
        CMpiInterface() {}
		Infrastructure::IKernel* GetKernel() { return m_pKernel; }
		
    private:

        // runtime type
        ERuntimeType   m_iRuntimeType;
        
        // pointer to the event manager
        Infrastructure::IEventManager *m_pEventManager;
        
        // pointer to the data manager
        Infrastructure::IDataManager  *m_pDataManager;
        
        // pointer to the kernel
        Infrastructure::IKernel    *m_pKernel;

        Infrastructure::CECAgent* m_pECAgent;

        Infrastructure::CLogger* m_pLogger;
    };


}}

#endif


