/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef _MRTE_MPI_UTILS_H
#define _MRTE_MPI_UTILS_H

#include "MpiAPI.h"
#include "MList.h"

namespace Martini { namespace MPI {

    typedef RTUtil::MList<TEventType> TEventTypeList;

    /**
     * @brief Returns the events belonging to the specified Event Group
     *
     * @param[out] eventList        Events belonging to the group
     * @param[in]  group            The event group
     *
     */
    void GetEventsInGroup(TEventTypeList *eventList, EEventGroup group);

    /**
     * @brief Checks whether an event belongs to an event group
     *
     * @param[in]   event           The event
     * @param[in]   group           The group
     *
     * @retval  true                The event belongs to the group
     * @retval  false               The event does not belong to the group
     */
    bool IsEventInGroup(TEventType event, EEventGroup group);

    /**
     * @brief Checks whether the specified filter is supported for the specified group
     *
     * @param[in]   group           The group
     * @param[in]   filter          The filter
     *
     * @retval  true                The filter is supported
     * @retval  false               The filter is not supported
     */
    bool DoesGroupSupportFilter(EEventGroup group, IEventFilter &filter);

    /**
     * @brief Find the group to which an event belongs
     *
     * @param[in]   event           The event
     *
     * @return      The group to which the event belongs
     */
    EEventGroup GetEventGroup(TEventType event);
    
}}

#endif

