/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef MRTE_INFRASTRUCTURE_DEFINITIONS_H
#define MRTE_INFRASTRUCTURE_DEFINITIONS_H

//#include "MPI.h"
#include "MpiAPI.h"
#include "MString.h"

#define EM_MAX_CLIENTS 64

#define MAX_CLIENTS_PER_EVENT 32

#define MAX_STRING 1024

#define MRTE_THREAD_DB_SIZE         0x100
#define MRTE_MODULE_DB_SIZE         0x100
#define MRTE_CLASS_DB_SIZE          0x1000
#define MRTE_CLASS_DB_KEY_BIT_SIZE  16
#define MRTE_METHOD_DB_SIZE         0x10000
#define MRTE_DB_SHIFT               2

namespace Martini { namespace Infrastructure {

const unsigned int MODULE_UNINITIALIZED = 0xFFFFFFFF;
const unsigned int MODULE_JIT = 1;
const unsigned int MODULE_INTERPRETED = 2;
const unsigned int MODULE_INLINED = 5;
const unsigned int MAX_JAVA_MODULE_ID = 5;
const char MODULE_INTERPRETED_NAME[] = "java.interpreted";
const char MODULE_INLINED_NAME[] = "java.inlined";

const char STATIC_CONSTRACTOR_NAME[] = "<static_constructor>";

const char JAVA_INSTANCE_CONSTRUCTOR_NAME[] = "<init>";
const char JAVA_CLASS_CONSTRUCTOR_NAME[] = "<clinit>";
const char JAVA_DESTRUCTOR_NAME[] = "finalize";

const char DOTNET_INSTANCE_CONSTRUCTOR_NAME[] = ".ctor";
const char DOTNET_CLASS_CONSTRUCTOR_NAME[] = ".cctor";
const char DOTNET_DESTRUCTOR_NAME[] = "Finalize";

enum EExternalControlTypes
{
    MPI_EC_START,
    MPI_EC_STOP,
    MPI_EC_PAUSE,
    MPI_EC_RESUME,
    MPI_EC_SNAPSHOT,
};

enum EEventImplementationType
{
    MPI_IMPLEMENTOR_NONE          = 0x00,
    MPI_VM                        = 0x01, //!< JVMPI, JVMTI, CLRPI
    MPI_INSTRUMENTATION           = 0x02, //!< Events generated using instrumentation
    MPI_TENTATIVE_INSTRUMENTATION = 0x04, //!< Events that can be generated either by the VM
                                          //!  or by instrumentation. Event source is determined
                                          //!  during runtime

    MPI_INTERNAL                  = 0x08, //!< Events that are generated internally
                                          //!  (i.e. new_method_event)
    MPI_EXTERNAL_CONTROL          = 0x10,
};

const MPI::TEventType EM_EVENT_INTERNAL_FIRST = 50;
const MPI::TEventType EM_EVENT_INTERNAL_CLASS_PREPARE = 
    EM_EVENT_INTERNAL_FIRST;                                        // JVMTI Class Prepare / 
                                                                    // JVMPI Class Load
                                                
const MPI::TEventType EM_EVENT_INTERNAL_CLASS_UNLOAD = 51;
const MPI::TEventType EM_EVENT_INTERNAL_CLASS_LOAD = 52;            // JVMTI ClassLoad event 

// EM_EVENT_INTERNAL_CLASS_LOAD_HOOK was replaced by standard event 
// EV_JAVA_CLASS_FILE_LOAD_HOOK 
// (Bugzilla 179182: https://bugs.eclipse.org/bugs/show_bug.cgi?id=179182).
//
// const MPI::TEventType EM_EVENT_INTERNAL_CLASS_LOAD_HOOK = 53;
//
const MPI::TEventType EM_EVENT_INTERNAL_FUNCTION_UNLOAD = 54;
const MPI::TEventType EM_EVENT_INTERNAL_EXCEPTION_UNWIND_ENTER = 55;
const MPI::TEventType EM_EVENT_INTERNAL_EXCEPTION_UNWIND_LEAVE = 56;
const MPI::TEventType EM_EVENT_INTERNAL_OBJECT_MOVE = 57;
const MPI::TEventType EM_EVENT_ARENA_NEW = 58;
const MPI::TEventType EM_EVENT_ARENA_DELETE = 59;
const MPI::TEventType EM_EVENT_MODULE_LOAD_FINISHED = 60;
const MPI::TEventType EM_EVENT_THREAD_NAME_CHANGED = 61;
const MPI::TEventType EM_EVENT_INTERNAL_MODULE_UNLOAD = 62;
const MPI::TEventType EM_EVENT_INTERNAL_VM_OBJECT_ALLOC = 63;       // JVMTI VMObjectAlloc event
const MPI::TEventType EM_EVENT_INTERNAL_APPDOMIAN_UNLOAD = 64;
const MPI::TEventType EM_EVENT_INTERNAL_MODULE_ATTACH_TO_ASSEMBLY = 65;

// End-sentinel for MPI events. Must be greater than the last event constant
const MPI::TEventType EM_EVENT_LAST = 66;

// .NET only:
// Search for prejitted functions -- mask similar to the JIT event in order 
// for efficient transition between them. There are no clients that register
// for cache search directly. This is important because event mask is index
// to the array of event clients
const MPI::TEventType EM_EVENT_FUNCTION_CACHE_SEARCH = 
    MPI::EV_JITTED_METHOD_LOADED | 0x80000000;  

enum EEventPriority
{
    EVENT_PRIORITY_LOW,
    EVENT_PRIORITY_NORMAL,
    EVENT_PRIORITY_HIGH,
};

#define EM_MAX_EVENTS_TOTAL    (MPI::EV_LAST + Infrastructure::EM_EVENT_LAST)

#define EM_EVENT_ILLEGAL 0

#define CLIENT_INSTANTIATE "MPICL_Instantiate"

// Macros for accessing the requested data types bit mask
#define DR_CONTAINS_THREAD_ID(mask) (((mask) & DR_THREAD_ID) == DR_THREAD_ID)
#define DR_CONTAINS_THREAD_CPU_TIME(mask) (((mask) & DR_THREAD_CPU_TIME) == DR_THREAD_CPU_TIME)
#define DR_CONTAINS_THREAD_ELAPSED_TIME(mask) (((mask) & DR_THREAD_ELAPSED_TIME) == DR_THREAD_ELAPSED_TIME)
#define DR_CONTAINS_THREAD_INFO(mask) (((mask) & DR_THREAD_INFO) == DR_THREAD_INFO)
#define DR_CONTAINS_MODULE_ID(mask) (((mask) & DR_MODULE_ID) == DR_MODULE_ID)
#define DR_CONTAINS_MODULE_NAME(mask) (((mask) & DR_MODULE_NAME) == DR_MODULE_NAME)
#define DR_CONTAINS_CLASS_ID(mask) (((mask) & DR_CLASS_ID) == DR_CLASS_ID)
#define DR_CONTAINS_CLASS_NAME(mask) (((mask) & DR_CLASS_NAME) == DR_CLASS_NAME)
#define DR_CONTAINS_METHOD_ID(mask)  (((mask) & DR_METHOD_ID) == DR_METHOD_ID)
#define DR_CONTAINS_METHOD_NAME(mask) \
    (((mask) & DR_METHOD_NAME) == DR_METHOD_NAME)
#define DR_CONTAINS_METHOD_SIGNATURE(mask) \
    (((mask) & DR_METHOD_SIGNATURE) == DR_METHOD_SIGNATURE)
#define DR_CONTAINS_NATIVE_METHOD_NAME(mask) \
    (((mask) & DR_JAVA_NATIVE_METHOD_NAME) == DR_JAVA_NATIVE_METHOD_NAME)
#define DR_CONTAINS_NATIVE_METHOD_SIGNATURE(mask) \
    (((mask) & DR_JAVA_NATIVE_METHOD_SIGNATURE) == DR_JAVA_NATIVE_METHOD_SIGNATURE)

#define DR_CONTAINS_SOURCE_FILE_NAME(mask)   \
    (((mask) & DR_SOURCE_FILE_NAME) == DR_SOURCE_FILE_NAME)

#define DR_CONTAINS_METHOD_LINE_NUMBERS(mask)       \
    (((mask) & DR_METHOD_LINE_NUMBERS) == DR_METHOD_LINE_NUMBERS)

#define DR_CONTAINS_METHOD_CODE(mask)           \
    (((mask) & DR_METHOD_CODE) == DR_METHOD_CODE)

#define DR_CONTAINS_NATIVE_TO_SRC_LINE_MAP(mask)           \
    (((mask) & DR_NATIVE_TO_SRC_LINE_MAP) == DR_NATIVE_TO_SRC_LINE_MAP)

#define DR_CONTAINS_NATIVE_TO_MANAGED_LINE_MAP(mask)           \
    (((mask) & DR_NATIVE_TO_MANAGED_LINE_MAP) == DR_NATIVE_TO_MANAGED_LINE_MAP)

#define DR_CONTAINS_MANAGED_TO_SRC_LINE_MAP(mask)           \
    (((mask) & DR_MANAGED_TO_SRC_LINE_MAP) == DR_MANAGED_TO_SRC_LINE_MAP)

#define DR_CONTAINS_JAVA_DYNAMIC_CODE(mask)           \
    (((mask) & DR_JAVA_DYNAMIC_CODE) == DR_JAVA_DYNAMIC_CODE)

#define DR_CONTAINS_OBJECT_ID(mask)   (((mask) & DR_OBJECT_ID) == DR_OBJECT_ID)
#define DR_CONTAINS_OBJECT_INFO(mask) (((mask) & DR_OBJECT_INFO) == DR_OBJECT_INFO)
#define DR_CONTAINS_HEAP_USAGE(mask)  (((mask) & DR_JAVA_HEAP_USAGE) == DR_JAVA_HEAP_USAGE)
#define DR_CONTAINS_ACTIVITY_PATH(mask)   (((mask) & DR_ACTIVITY_PATH) == DR_ACTIVITY_PATH)
#define DR_CONTAINS_COMMAND_ID(mask) (((mask) & DR_COMMAND_ID) == DR_COMMAND_ID)
#define DR_CONTAINS_COMMAND_DATA(mask) (((mask) & DR_COMMAND_DATA) == DR_COMMAND_DATA)
#define DR_CONTAINS_ABSOLUTE_NATIVE_STACK_TRACE(mask)   (((mask) & DR_ABSOLUTE_NATIVE_STACK_TRACE) == DR_ABSOLUTE_NATIVE_STACK_TRACE)
#define DR_CONTAINS_VM_RELATIVE_STACK_TRACE(mask)   (((mask) & DR_VM_RELATIVE_STACK_TRACE) == DR_VM_RELATIVE_STACK_TRACE)
#define DR_CONTAINS_METHOD_METADATA_ID(mask) \
    (((mask) & DR_DOTNET_METHOD_TOKEN) == DR_DOTNET_METHOD_TOKEN)
#define DR_CONTAINS_MONITOR_TIMEOUT(mask) (((mask) & DR_MONITOR_TIMEOUT) == DR_MONITOR_TIMEOUT)
#define DR_CONTAINS_MONITOR_TIMED_OUT(mask) (((mask) & DR_MONITOR_TIMED_OUT) == DR_MONITOR_TIMED_OUT)
#define DR_CONTAINS_THREAD_INTERACTION_TYPE(mask) (((mask) & DR_THREAD_INTERACTION_TYPE) == DR_THREAD_INTERACTION_TYPE)
#define DR_CONTAINS_MONITOR_OWNER_THREAD_ID(mask) (((mask) & DR_MONITOR_OWNER_THREAD_ID) == DR_MONITOR_OWNER_THREAD_ID)
#define DR_HAS_THREAD_DATA(mask) \
    ( ((mask) & DR_THREAD_ID) || ((mask) & DR_THREAD_ELAPSED_TIME) || ((mask) & DR_THREAD_CPU_TIME)\
    ) 
#define DR_CONTAINS_ALLOC_VM_INSTRUCTION_OFFSET(mask) \
    (((mask) & DR_ALLOC_VM_INSTRUCTION_OFFSET) == DR_ALLOC_VM_INSTRUCTION_OFFSET)
#define DR_CONTAINS_OBJECT_AGE(mask) (((mask) & DR_OBJECT_AGE) == DR_OBJECT_AGE)

// Constants defining the data items supported by each MPI data request
const MPI::BitSet DR_SUPPORTED_MODULE_INFO = MPI::DR_MODULE_NAME;

const MPI::BitSet DR_SUPPORTED_CLASS_INFO = MPI::DR_CLASS_NAME | 
                                            MPI::DR_SOURCE_FILE_NAME |
                                            MPI::DR_JAVA_NATIVE_CLASS_NAME;


const MPI::BitSet DR_SUPPORTED_METHOD_INFO = MPI::DR_METHOD_NAME | 
                                             MPI::DR_METHOD_SIGNATURE |
                                             MPI::DR_JAVA_NATIVE_METHOD_NAME |
                                             MPI::DR_JAVA_NATIVE_CLASS_NAME |
                                             MPI::DR_JAVA_NATIVE_METHOD_SIGNATURE |
                                             MPI::DR_SOURCE_FILE_NAME |
                                             MPI::DR_METHOD_LINE_NUMBERS |
                                             MPI::DR_CLASS_ID |
                                             MPI::DR_CLASS_NAME |
                                             MPI::DR_MODULE_ID |
                                             MPI::DR_MODULE_NAME |
                                             MPI::DR_METHOD_CODE |
                                             MPI::DR_NATIVE_TO_SRC_LINE_MAP |
                                             MPI::DR_NATIVE_TO_MANAGED_LINE_MAP |
                                             MPI::DR_MANAGED_TO_SRC_LINE_MAP |
                                             MPI::DR_DOTNET_MODULE_PREJIT |
                                             MPI::DR_DOTNET_METHOD_TOKEN;

const MPI::BitSet DR_SUPPORTED_THREAD_INFO = MPI::DR_THREAD_NAME |
                                             MPI::DR_THREAD_GROUP |
                                             MPI::DR_THREAD_PARENT_GROUP |
                                             MPI::DR_THREAD_ELAPSED_TIME |
                                             MPI::DR_THREAD_CPU_TIME |
                                             MPI::DR_ABSOLUTE_NATIVE_STACK_TRACE |
                                             MPI::DR_VM_RELATIVE_STACK_TRACE |
                                             MPI::DR_CURRENT_MONITOR |
                                             MPI::DR_OBJECT_ID |
                                             MPI::DR_THREAD_STATE;

const MPI::BitSet DR_SUPPORTED_ALL_THREAD_INFO = MPI::DR_THREAD_NAME |
                                                 MPI::DR_THREAD_GROUP |
                                                 MPI::DR_THREAD_PARENT_GROUP |
                                                 MPI::DR_VM_RELATIVE_STACK_TRACE |
                                                 MPI::DR_CURRENT_MONITOR |
                                                 MPI::DR_OBJECT_ID |
                                                 MPI::DR_THREAD_STATE;

const MPI::BitSet DR_SUPPORTED_OBJECT_INFO = MPI::DR_OBJECT_INFO |
                                             MPI::DR_MONITOR_OWNER_THREAD_ID |
                                             MPI::DR_MONITOR_OWN_WAITERS |
                                             MPI::DR_MONITOR_NOTIFY_WAITERS;

// Struct that holds client's information
struct SClientInfo
{
    RTUtil::MCString szClientName;   // client name
};

}}

#endif

