/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef _MRTE_PARAM_CHECKER_H
#define _MRTE_PARAM_CHECKER_H

#include "MpiAPI.h"

namespace Martini { namespace Infrastructure
{
    // A bit-mask of all supported data items. Used internally for validation
    const MPI::TDataRequestType DR_VALID_DATA =  
        MPI::DR_THREAD_ID | MPI::DR_THREAD_INFO | MPI::DR_THREAD_ELAPSED_TIME |
        MPI::DR_THREAD_CPU_TIME | MPI::DR_MODULE_ID | MPI::DR_MODULE_NAME | 
        MPI::DR_CLASS_ID | MPI::DR_CLASS_NAME | MPI::DR_METHOD_ID | 
        MPI::DR_METHOD_NAME | MPI::DR_METHOD_SIGNATURE |
        MPI::DR_JAVA_NATIVE_METHOD_NAME | MPI::DR_JAVA_NATIVE_METHOD_SIGNATURE |
        MPI::DR_SOURCE_FILE_NAME | MPI::DR_METHOD_LINE_NUMBERS |
        MPI::DR_METHOD_CODE | MPI::DR_NATIVE_TO_SRC_LINE_MAP | 
        MPI::DR_NATIVE_TO_MANAGED_LINE_MAP | MPI::DR_MANAGED_TO_SRC_LINE_MAP |
        MPI::DR_DOTNET_MODULE_PREJIT | MPI::DR_JAVA_DYNAMIC_CODE |
        MPI::DR_OBJECT_ID | MPI::DR_OBJECT_INFO | MPI::DR_JAVA_HEAP_USAGE |
        MPI::DR_ACTIVITY_PATH | MPI::DR_ABSOLUTE_NATIVE_STACK_TRACE | 
        MPI::DR_VM_RELATIVE_STACK_TRACE | MPI::DR_DOTNET_METHOD_TOKEN | 
        MPI::DR_DOTNET_GC_MOVED_REF_INFO;
    
    //TODO: rewrite the param checker
    class CParamChecker  
    {
    public:
	    CParamChecker();
	    ~CParamChecker();
        TResult CheckClient(MPI::TId clientId);
        TResult CheckEvent(MPI::TEventType event);
        TResult CheckClientAndPtr(MPI::TId clientId, const void *ptr);
        TResult CheckEventAndPtr(MPI::TEventType mpiEvent, const void *ptr);
        TResult CheckClientAndEvent(MPI::TId clientId, MPI::TEventType mpiEvent);
        TResult CheckClientAndData(MPI::TId clientId, MPI::BitSet data);
        TResult CheckClientAndEventAndPtr(MPI::TId clientId, MPI::TEventType mpiEvent, const void *ptr);
        TResult CheckClientAndDataAndPtr(MPI::TId clientId, MPI::BitSet data, const void *ptr);
        TResult CheckClientAndEventAndData(MPI::TId clientId, MPI::TEventType mpiEvent, MPI::BitSet data);
        TResult CheckClientAndEventAndDataAndPtr(MPI::TId clientId, MPI::TEventType mpiEvent, MPI::BitSet data, const void *ptr);
//        TResult CheckParams(MPI::TId clientId, MPI::TEventType mpiEvent, TMpiSelectiveAttr attr);
        void SetClientIdLimits(MPI::TId min, MPI::TId max);
        void SetEventsLimits(MPI::TEventType min, MPI::TEventType max);
    private:
        TResult CheckData(MPI::BitSet data);
        TResult CheckEventData(MPI::TEventType event, MPI::BitSet data);
        TResult CheckPtr(const void *ptr);
        void InitEventDataItems();
//        TResult CheckAttr(TMpiSelectiveAttr attr);

        // max valid value for a client
        MPI::TId m_MaxClientId;

        // min valid value for a client
        MPI::TId m_MinClientId;

        // max valid value for an event
        MPI::TEventType m_MaxEvent; 

        // min valid value for an event
        MPI::TEventType m_MinEvent;

        // an array that stores the supported data items for each event
        unsigned int *m_EventDataItems;
    };
}}
#endif // _MRTE_PARAM_CHECKER_H





















