/*****************************************************************************
 * Copyright (c) 1997, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id: ThreadAdaptor.h,v 1.4 2010/05/11 16:32:23 jwest Exp $ 
 *****************************************************************************/
//
#ifndef MRTE_THREADADAPTORIMPL
#define MRTE_THREADADAPTORIMPL

#include "InstrumentationAdaptorBase.h"
#include "MVector.h"
#include "MHash.h"
#include "MString.h"
#include "IdAllocator.h"

#ifdef THREADADAPTOR_EXPORTS
#define THREADADAPTOR_API API_EXPORT
#else
#define THREADADAPTOR_API API_IMPORT
#endif

#define THREADADAPTOR_DLL_NAME "ThreadAdaptor"

namespace Martini { namespace ThreadAdaptor {
    
    /**
     * @brief Function prototype for the callThreadInteraction native method of the 
     * Thread Proxy Java class
     *
     * This is a prototype for a function that provides an implementation of the 
     * callThreadInteraction native method of ThreadProxy.java.
     */
    typedef void (JNICALL *TThreadInteractionHandler)(JNIEnv *env, 
                                                      jclass self, 
                                                      jobject obj, 
                                                      jint methodID);

    struct SHookMethodCall 
    {
        const char *methodName;
        JIE::TConstantPoolIndex cpCallback;
    };

    /**
     * @brief ThreadAdaptor class
     */
    class CThreadAdaptor : public Infrastructure::CInstrumentationAdaptorBase
    {
    public:
        CThreadAdaptor();
        ~CThreadAdaptor();
        
        // IInstrumentationAdaptor methods

        virtual TResult Init(Infrastructure::ILogAssert *pLogger = NULL,
                             MPI::IEventFilter *pFilter = NULL,
                             MPI::BitSet configFlags = MPI::CF_NONE);

        virtual TResult ModifyClass(MPI::TId classId, 
                                    const Infrastructure::SClassFile &classToInstrument,
                                    TMemoryAllocatorFunc funcAllocator,
                                    Infrastructure::SClassFile *pInstrumentedClass,
                                    Infrastructure::IInstrumentationContext *pContext = NULL);

        virtual TResult ModifyByteCodes(MPI::TId classId, 
                                        const Infrastructure::SClassFile &classToInstrument,
                                        TMemoryAllocatorFunc funcAllocator,
                                        Infrastructure::SClassFile *pInstrumentedClass,
                                        Infrastructure::IInstrumentationContext *pContext = NULL);

    private:

        MPI::IThreadInteractionFilter *m_pFilter; // Callback function for Thread-selectivity

        // Check if the class can be instrumented
        TResult CanInstrumentClass(const Infrastructure::SAdaptorClassInfo &info);

        // Check if the method can be instrumented
        bool CanInstrumentMethod(const JIE::SJavaMethodInfo &methodInfo);

        // Add Thread instrumentation to the specified class file
        TResult DoThreadInstrumentation(JIE::IJavaClass *pJavaClass,
                                      const Infrastructure::SAdaptorClassInfo &classInfo,
                                      bool bJVMInitDone);
    
        bool IsProblematicMethod(const char *szClassName, const char *szMethodName);

        // Copies a class file buffer
        TResult CopyClassFile(Infrastructure::SClassFile *pDest, 
                              const Infrastructure::SClassFile& src,
                              TMemoryAllocatorFunc funcAllocator);



        TResult InstrumentMethodCalls(JIE::IJavaClass *pClass,
                                      const Infrastructure::SAdaptorClassInfo &classInfo,
                                      SHookMethodCall *hooks, size_t hooks_num,
                                      SHookMethodCall *sleepHooks, size_t sleep_hooks_num);

        bool CheckFilter(const Infrastructure::SAdaptorClassInfo &classInfo,
                         const JIE::SJavaMethodInfo &methodInfo);


        TResult AddInstrumentationToMethod(JIE::IJavaClass *pClass,
                                           JIE::IJavaMethod *pMethod,
                                           SHookMethodCall *hooks, size_t hooks_num,
                                           SHookMethodCall *sleepHooks, size_t sleep_hooks_num,
                                           const Infrastructure::SAdaptorClassInfo &classInfo,
                                           const JIE::SJavaMethodInfo &methodInfo);

        TResult AddNotifyProbeBeforeInstr(MIE::IInstruction *pInst,
                                          JIE::TConstantPoolIndex cpCallback);

        TResult AddNotifyProbesBeforeSleepInstr(MIE::IInstruction *pInst,
                                          JIE::TConstantPoolIndex cpStartCallback,
                                          JIE::TConstantPoolIndex cpEndCallback
                                          );

        // Instrumentations names
        MIE::SWideString m_wzThreadProxyCallbackClassName;
        MIE::SWideString m_wzNotifyCallbackName;
        MIE::SWideString m_wzNotifyCallbackSig;
        MIE::SWideString m_wzNotifyAllCallbackName;
        MIE::SWideString m_wzNotifyAllCallbackSig;
        MIE::SWideString m_wzInterruptCallbackName;
        MIE::SWideString m_wzInterruptCallbackSig;
        MIE::SWideString m_wzStartCallbackName;
        MIE::SWideString m_wzStartCallbackSig;

        MIE::SWideString m_wzSleepStartCallbackName;
        MIE::SWideString m_wzSleepStartCallbackSig;

        MIE::SWideString m_wzSleepEndCallbackName;
        MIE::SWideString m_wzSleepEndCallbackSig;

    }; // class CThreadAdaptor

    /**
     * @brief An API for getting the Instrumentation Adaptor interface
     *
     * @return IInstrumentationAdaptor*     A pointer to the adaptor's singleton interface
     */ 
     extern "C" THREADADAPTOR_API 
     Infrastructure::IInstrumentationAdaptor *GetInstrumentationAdaptor();

}} // namespace Martini::ThreadAdaptor

#endif // #define MRTE_THREADADAPTORIMPL
