/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//

#ifndef MRTE_VALIDITYCHECKS
#define MRTE_VALIDITYCHECKS

#define CHECK_ALLOC(X)                      \
    if (!X)                                 \
    {                                       \
        return MRTE_ERROR_OUT_OF_MEMORY;    \
    }

#define CHECK_TRESULT(X)                    \
    if (X != MRTE_RESULT_OK)                \
    {                                       \
        return X;                           \
    }

#define CHECK_RETURN_NULL(X)                \
    if (NULL == X)                          \
    {                                       \
        return NULL;                        \
    }

#define CHECK_NULL_RETURN_ERROR(X)          \
    if (NULL == X)                          \
    {                                       \
        return MRTE_ERROR_FAIL;             \
    }

#endif // MRTE_VALIDITYCHECKS

