/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//
#ifndef MRTE_WIDESTRINGUTILS
#define MRTE_WIDESTRINGUTILS

#include "MpiAPI.h"

namespace Martini { namespace MIE {

class CWideStringUtils  
{
public:
    static void InitWideString(SWideString &ws, const char *sz);
    static char* WideStringToCString(const SWideString &ws);
    static void FreeWideString(const SWideString &ws);
    static void AllocateWideString(SWideString &ws, unsigned int length);
    static void AssignText(SWideString &ws, const char *szText);
    static void ReallocateWideString(SWideString &ws);

private:
    // utility class. prevent construction
	CWideStringUtils();

};

}} // namespace MIE

#endif // #define WIDESTRINGUTILS
