/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
#include "BciUtils.h"

#include <string.h>

using namespace Martini::JIE;
using namespace Martini::MIE;

//////////////////////////////////////////////////////////////////////////
// class CBciUtils implementation


CBciUtils::CBciUtils()
{

}

//
// Convert a "Utf8" constant-pool entry to wide string
// 
// Parameters:
//      - ws [in, out]: a wide string allocated by the caller.
//      - pUtf8Info [in]: utf8 constant-pool entry
//
// Returns:
//      MRTE_RESULT_OK: success
//      MRTE_ERROR_BUFFER_TOO_SHORT: the allocated ws is not big enough. When this happens, 
//                                   ws.uiActualSize is updated with the required buffer
//                                   size.
//
TResult CBciUtils::CCPUtf8InfoToWideString(SWideString &ws, 
                                           const CCPUtf8Info *pUtf8Info)
{
    //TODO: current code treats pUtf8Info as ASCII. Need to add UTF-8 support
    size_t cbString = pUtf8Info->GetLength();
    char *szString = new char[cbString + 1]; // +1 for the terminating NULL
    strncpy(szString, (char*)pUtf8Info->GetBytes(), cbString);
    szString[cbString] = 0; // add the null-terminating character
    ws.uiActualSize = cbString;
    if (cbString > ws.uiBufferSize)
    {
        delete [] szString;
        return MRTE_ERROR_BUFFER_TOO_SHORT;
    }
    CWideStringUtils::AssignText(ws, szString);
    delete [] szString;
    return MRTE_RESULT_OK;
}

char* CBciUtils::CCPUtf8InfoToCString(const CCPUtf8Info *pUtf8Info)
{
    //TODO: current code treats pUtf8Info as ASCII. Need to add UTF-8 support
    size_t cbString = pUtf8Info->GetLength();
    char *szString = new char[cbString + 1]; // +1 for the terminating NULL
    strncpy(szString, (char*)pUtf8Info->GetBytes(), cbString);
    szString[cbString] = 0; // add the null-terminating character
    return szString;
}
