/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//
#ifndef MRTE_BCIUTILS
#define MRTE_BCIUTILS

#include <string> // missing from JClassFile.h and required to compile on Linux

#include "WideStringUtils.h"
#include "JClassFile.h"

namespace Martini { namespace JIE {

class CBciUtils  
{
public:
    // convert a "Utf8" constant-pool entry to wide string
    static TResult CCPUtf8InfoToWideString(MIE::SWideString &ws, const CCPUtf8Info *pUtf8Info);

    // convert a "Utf8" constant-pool entry to a C String (char *)
    static char* CCPUtf8InfoToCString(const CCPUtf8Info *pUtf8Info);

private:
    // utility class. prevent construction
	CBciUtils();

};

}} // namespace JIE

#endif // #define MRTE_BCIUTILS
