/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//

#ifndef MRTE_FLOWGRAPHNODE
#define MRTE_FLOWGRAPHNODE

#include "MRTETypes.h"
#include "MIEInstruction.h"

namespace Martini { namespace MIE {

class CFlowGraph;                   // forward declaration
class COrgInstructionsListIterator; // forward declaration

class CFlowGraphNode  
{
public:
	CFlowGraphNode(CMIEInstruction *pInst);
	virtual ~CFlowGraphNode();
    CMIEInstruction* GetInstruction() { return m_pInst; }

private:
    friend class CFlowGraph;
    friend class COrgInstructionsListIterator;

    TMRTEHandle m_handle;     // handle to the list item in which the node is stored
    CFlowGraphNode *m_pfgnNextOriginal;     // next "original" instruction node
    CFlowGraphNode *m_pfgnPrevOriginal;     // previous "original" instruction node
    CMIEInstruction *m_pInst;       // the MIE Instruction object stored in this node
};

}}

#endif // MRTE_FLOWGRAPHNODE
