/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
#pragma warning (disable:4786)

#include "JavaClass.h"
#include "JIEImpl.h"
#include "JIEUtils.h"

#include "LibraryLoader.h"
#include "OSA.h"

// first ids are reserved for threads in the prf resolution
#define JIE_FIRST_METHOD_ID 0x10000 

using namespace Martini::JIE;
using namespace Martini::OSA;

extern "C" JIE_API IJIE *GetJIEInstance()
{
    static CJIE s_jie;
    return (IJIE*)&s_jie;
}


//////////////////////////////////////////////////////////////////////////
// class CJIE implementation


unsigned int CJIE::GetVersion() const
{
    //TODO: fix version
    return 0;
}

IJavaClass *CJIE::GetClassInterface(const unsigned char *pucClassFile,
                                    unsigned int uiClassSize) const
{
    IJavaClass *pClass;
    try
    {
        pClass = new CJavaClass(pucClassFile, uiClassSize);
    }
    catch (...)
    {
        // Illegal class file
        pClass = NULL;
    }
    return pClass; 
}

void CJIE::EnableStackMapCalculation() const
{
    TResult res = BindJpiFunctions();
    if (MRTE_SUCCEEDED(res))
    {
        CJieGlobals::Instance()->isStackMapCalcEnabled = true;
    }
}

TResult CJIE::BindJpiFunctions() const
{
    ILibraryLoader *pJpiLoader = LoadBistroLibrary("JPI");
    if (!pJpiLoader)
    {
        return MRTE_ERROR_FAIL;
    }

    CJieGlobals::Instance()->pfnJPI_AttachCurrentThread = 
        (TJpiAttachCurrentThread)pJpiLoader->GetEntry("JPI_AttachCurrentThread");
    if (!CJieGlobals::Instance()->pfnJPI_AttachCurrentThread)
    {
        return MRTE_ERROR_FAIL;
    }

    CJieGlobals::Instance()->pfnJPI_DetachCurrentThread = 
        (TJpiDetachCurrentThread)pJpiLoader->GetEntry("JPI_DetachCurrentThread");
    if (!CJieGlobals::Instance()->pfnJPI_DetachCurrentThread)
    {
        return MRTE_ERROR_FAIL;
    }
    
    pJpiLoader->Destroy();

    return MRTE_RESULT_OK;
}
