/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//
#ifndef MRTE_JIEIMPL
#define MRTE_JIEIMPL

#include "JIE.h"

namespace Martini { namespace JIE {

    class CJIE : public IJIE
    {
    public:
        // IMIE methods
        virtual unsigned int GetVersion() const;

        // IJIE methods
        virtual IJavaClass *GetClassInterface(const unsigned char *pucClassFile,
                                              unsigned int uiClassSize) const;
        virtual void EnableStackMapCalculation() const;
        
    private:
        TResult BindJpiFunctions() const;
        
    }; // class CJIE

}} // namespace JIE

#endif // #define MRTE_JIEIMPL
