/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//

#ifndef MRTE_JIEINSTRUCTIONCODEC
#define MRTE_JIEINSTRUCTIONCODEC

#include "ModuleJ.h"

#include "MIEInstructionCodec.h"
#include "BCIToMIEInstructionMapper.h"
#include "MIEProtectedBlock.h"
#include "MList.h"


//
// The following macros are used to map a 'Treturn' instruction to its relevant 
// Tload/Tstore instruction (where T is one of i,l,d,f,a).
// This relies on the order of the opcodes in the instruction set, and we assume
// it is not going to change in the future :)
//
#define GET_LOAD_OPCODE_FOR_RETURN(x) (EMnemonic)(x - (MNM_IRETURN - MNM_ILOAD))
#define GET_STORE_OPCODE_FOR_RETURN(x) (EMnemonic)(x - (MNM_IRETURN - MNM_ISTORE))

namespace Martini { namespace MIE {

//TODO: refactor. move all generic (not Java specific) code to base class and use template methods where needed
class CJIEInstructionCodec : public IMIEInstructionCodec
{
public:
    typedef RTUtil::MList<CMIEProtectedBlock*> TProtectedBlocksList;

    CJIEInstructionCodec(CMethodJ *pBciMethod, CJClassBuilder *pClassBuilder);
    virtual ~CJIEInstructionCodec();

    // IMIEInstructionCodec methods
    virtual TResult Decode(CFlowGraph *pFlowGraph);
    virtual TResult Encode(CFlowGraph &flowGraph);

private:
    CMethodJ *m_pBCIMethod;             // the BCI Java method being processed by the Codec
    CJClassBuilder *m_pBCIClassBuilder; // the BCI Java class being processed by the Codec
    
    static CBCIToMIEInstructionMapper sm_BCI2MIEMapper;

    TResult UpdateBranchTargets(CFlowGraph *pFlowGraph);
    TResult DecodeProtectedBlocks(TProtectedBlocksList *lstBlocks);
    TResult AddProtectedBlocksToGraph(CFlowGraph* pFlowGraph,
                                      const TProtectedBlocksList &lstBlocks);
    CMIEInstruction* GetTargetInstructionFromOffset(CFlowGraph *pFlowGraph, 
                                                    unsigned int uiOffset);
    void GenerateBCIMethodCode(CFlowGraph &flowGraph);
    void UpdateInstructionOffsets(CFlowGraph &flowGraph);
    CMIEProtectedBlock* CreateProtectedBlock(CFlowGraph &flowGraph,
                                             CMIEInstruction *pEndTry);
    void GenerateBCIMethodExceptionTable(const TProtectedBlocksList& blockList);
    void UpdateBCIMethodLineNumberTable(CFlowGraph &flowGraph);
    TResult ProcessTryFinallyBlocks(CFlowGraph *pFlowGraph);
    TResult ProcessTryFinallyBlocksForCtors(CFlowGraph *pFlowGraph);
    TResult ProcessTryFinallyBlocksNoJsr(CFlowGraph *pFlowGraph);
    void UpdateBCIMethodLocalVariableTable(CFlowGraph &flowGraph,
                                           CLocalVariableTable &originalLocalVarTable,
                                           CLocalVariableTypeTable &originalLocalVarTypeTable,
                                           unsigned int uiOriginalCodeLength);

    // helpers
    TResult AddCodeGenInstBefore(CFlowGraph *pFlowGraph,
                                        CMIEInstruction *pMarkerInst,
                                        CMIEInstruction *pNewInst);

    TResult AddCodeGenInstAfter(CFlowGraph *pFlowGraph,
                                        CMIEInstruction *pMarkerInst,
                                        CMIEInstruction *pNewInst);

    CMIEInstruction* CreateGoto(CMIEInstruction *pTarget);
    CMIEInstruction* CreateJsr(CMIEInstruction *pTarget);
    CMIEInstruction* CreateLoadStore(EMnemonic mnem, unsigned int uiVarInd);
    CMIEInstruction* CreateRet(unsigned int uiVarInd);
    void AddJsrBeforeReturn(CMIEInstruction *pReturn, CMIEInstruction *pJsrTarget,
                            CFlowGraph *pFlowGraph);
};

}}

#endif // MRTE_MIEINSTRUCTIONCODEC

