/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
#ifdef EM64T_ARCH
#pragma runtime_checks( "", off )
#endif

#include "JIEUtils.h"
#include "JIE.h"
#include "MRTEInfrastructureDefinitions.h"

#include <stdlib.h>
#include <string.h>
#include <assert.h>

using namespace Martini::JIE;
using namespace Martini::RTUtil;

///////////////////////////////////////////////////////////////////////////////
// Global constants

// mapping of JIE's EVarType enum to BCI's CJavaType
const CJavaType::jtype_t VarTypeToJavaType[] = 
{
    CJavaType::J_UNKNOWN,       // VT_NONE
    CJavaType::J_BYTE,          // VT_BYTE
    CJavaType::J_SHORT,         // VT_SHORT
    CJavaType::J_INT,           // VT_INT
    CJavaType::J_LONG,          // VT_LONG
    CJavaType::J_FLOAT,         // VT_FLOAT
    CJavaType::J_DOUBLE,        // VT_DOUBLE
    CJavaType::J_CHAR,          // VT_CHAR
    CJavaType::J_BOOLEAN,       // VT_BOOLEAN
    CJavaType::J_CLASS          // VT_REFERENCE
};
/*
    enum EVarType
    {
        VT_NONE,
        VT_BYTE,        //!< byte
        VT_SHORT,       //!< short
        VT_INT,         //!< integer
        VT_LONG,        //!< long 
        VT_FLOAT,       //!< float
        VT_DOUBLE,      //!< double
        VT_CHAR,        //!< character
        VT_BOOLEAN,     //!< boolean
        VT_REFERENCE,   //!< reference
        VT_LAST,
    };

	typedef enum
	{
		J_BYTE,
		J_CHAR,
		J_DOUBLE,
		J_FLOAT,
		J_INT,
		J_LONG,
		J_CLASS,
		J_SHORT,
		J_BOOLEAN,
		J_VOID,
		J_ARRAY,
		J_UNKNOWN,
		J_LAST
	} jtype_t;
*/

///////////////////////////////////////////////////////////////////////////////
// UTF-8 related functions

// temporary until we decide how we work with unicode
//typedef unsigned short WCHAR;
typedef wchar_t WCHAR; //changed the typedef from unsigned short for linux compatibility

TResult Utf8ToWChar(U8 *bytes, U16 length, WCHAR *pBuffer, unsigned int uiBufferSize)
{
	unsigned int i = 0;

	while (length)
	{
		if ((*bytes | 0x7F) == 0x7F)
		{
			--length;
			pBuffer[i] = *(bytes++);
		}
		else if (((*bytes << 2) | 0x7F) == 0x7F)
		{
			length -= 2;
			WCHAR x = *(bytes++);
			WCHAR y = *(bytes++);
			pBuffer[i] = ((x & 0x1F) << 6) + (y & 0x3F);
		}
		else
		{
			length -= 3;
			WCHAR x = *(bytes++);
			WCHAR y = *(bytes++);
			WCHAR z = *(bytes++);
			pBuffer[i] = ((x & 0xF) << 12) + ((y & 0x3F) << 6) + (z & 0x3F);
		}
		++i;
        if (i >= uiBufferSize)
        {
            return MRTE_ERROR_BUFFER_TOO_SHORT;
        }
	}
	pBuffer[i] = 0;
    return MRTE_RESULT_OK;
}


TResult Utf8ToChar(U8 *bytes, U16 length, MCString *pBuffer)
{
	WCHAR tmp[MAX_STRING];
	WCHAR *pTmpBuffer = (WCHAR *)&tmp;
	bool bIspTmpBufferAllocated = false;

	// convert from UTF8 to wide
    TResult iRes = Utf8ToWChar(bytes, length, pTmpBuffer, MAX_STRING);
    unsigned int uiBufferSize = MAX_STRING;

	while (iRes == MRTE_ERROR_BUFFER_TOO_SHORT)
    {
		uiBufferSize = uiBufferSize << 1; // multiple by 2
		pTmpBuffer = new WCHAR[uiBufferSize];
		if (pTmpBuffer == NULL)
		{
			return MRTE_ERROR_OUT_OF_MEMORY;
		}
		bIspTmpBufferAllocated = true;
		
        iRes = Utf8ToWChar(bytes, length, pTmpBuffer, uiBufferSize);
		if (iRes == MRTE_ERROR_BUFFER_TOO_SHORT)
		{
			delete [] pTmpBuffer;
		}
    }
	// convert from wide to multi-byte
    char *szBuffer = (char *)new char[uiBufferSize*2]; // allocate twice as much memory to guarantee conversion will succeed
    if (szBuffer == NULL)
    {
		assert(0);
        return MRTE_ERROR_OUT_OF_MEMORY;
    }

    unsigned int uiActualWrittenBytes = (unsigned int)wcstombs(szBuffer, pTmpBuffer, uiBufferSize*2); 
    iRes = pBuffer->Set(szBuffer);
	if (bIspTmpBufferAllocated)
	{
		delete [] pTmpBuffer;
	}
    delete [] szBuffer;
    return iRes;
}


U16 WCharToUtf8(U8 *pDest, unsigned int uiDesBufferSize, const WCHAR *pSource)
{
	U16 len = (U16)wcslen(pSource);
	U16 j = 0; // the index of the return array
	// the loop runs on the index of the source array
	for (U16 i = 0; i < len; ++i)
	{
		if ((j + 3) >= (U16)uiDesBufferSize)
        {
            assert(0);
            return 0;
        }
        if (pSource[i] >= 0x0001 && pSource[i] <= 0x007F)
		{
			pDest[j++] = (U8)pSource[i];
		}
		else if (pSource[i] == 0x0000 || (pSource[i] >= 0x0080 && pSource[i] <= 0x07FF))
		{
			pDest[j++] = 0xC0 + (U8)(pSource[i] >> 5);
			pDest[j++] = 0x80 + (U8)(pSource[i] & 0x001F);
		}
		else // source[i] >= 0x0800 && source[i] <= 0xFFFF
		{
			pDest[j++] = 0xE0 + (U8)(pSource[i] >> 10);
			pDest[j++] = 0x80 + (U8)((pSource[i] & 0x0FC0) >> 5);
			pDest[j++] = 0x80 + (U8)(pSource[i] & 0x001F);
		}
	}

	return j;
}

U16 CharToUtf8(U8 *pDest, unsigned int uiDesBufferSize, const char *pSource)
{
	WCHAR tmp[MAX_STRING];
    unsigned int uiSourceSize = (unsigned int)strlen(pSource) + 1;
    // convert from multibyte to wide
	unsigned int uiRequiredSize = (unsigned int)mbstowcs(NULL, pSource, uiSourceSize);
    if (uiRequiredSize > MAX_STRING)
    {
        assert(0);
        return 0;
    }
    uiRequiredSize = (unsigned int)mbstowcs(tmp, pSource, uiSourceSize);
    if (uiRequiredSize == (unsigned int)(-1))
    {
        // conversion failed
        assert(0);
        return 0;
    }
	
    // convert from wide to UTF8
    U16 ret = WCharToUtf8(pDest, uiDesBufferSize, tmp);
	return ret;
}

//////////////////////////////////////////////////////////////////////////
// CJieGlobals implementation

Martini::JIE::CJieGlobals* Martini::JIE::CJieGlobals::s_pInstance = NULL;
