/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//

#ifndef MRTE_JIEUTILS
#define MRTE_JIEUTILS

#include "MRTETypes.h"
#include "MRTEResults.h"
#include "MString.h"
#include "JavaHelpers.h"

#include "jni.h"

///////////////////////////////////////////////////////////////////////////////
// Global constants

// mapping of JIE's EVarType enum to BCI's CJavaType
extern const CJavaType::jtype_t VarTypeToJavaType[];

// temporary until we decide how we work with Unicode

typedef wchar_t WCHAR; //changed the typedef from unsigned short for Linux compatibility

TResult Utf8ToWChar(U8 *bytes, U16 length, WCHAR *pBuffer, unsigned int uiBufferSize);
TResult Utf8ToChar(U8 *bytes, U16 length, Martini::RTUtil::MCString *pBuffer);
U16 WCharToUtf8(U8 *pDest, unsigned int uiDesBufferSize, const WCHAR *pSource);
U16 CharToUtf8(U8 *pDest, unsigned int uiDesBufferSize, const char *pSource);

typedef TResult (*TJpiAttachCurrentThread) (JNIEnv **ppJNIEnv, bool *bAttached);
typedef void (*TJpiDetachCurrentThread) ();

namespace Martini { namespace JIE {

    class CJieGlobals
    {
    public:

        static CJieGlobals* Instance() 
        {
            if (0 == s_pInstance)
            {
                s_pInstance = new CJieGlobals();
            }
            return s_pInstance;
        }

        TJpiAttachCurrentThread pfnJPI_AttachCurrentThread;
        TJpiDetachCurrentThread pfnJPI_DetachCurrentThread;
        
        bool isStackMapCalcEnabled;

    protected:
        static CJieGlobals* s_pInstance;

        CJieGlobals(): 
            pfnJPI_AttachCurrentThread(0), pfnJPI_DetachCurrentThread(0),
            isStackMapCalcEnabled(false)
            {}

    };
}} // namespace Martini::JIE

#endif // MRTE_JIEUTILS
