/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//
#ifndef MRTE_JAVALCLASS
#define MRTE_JAVALCLASS

#include "class_inerface_int.h"
#include "JIE.h"
#include "JClassBuilder.h"
#include "JavaMethods.h"
#include "JavaFields.h"
#include "ModuleJ.h"

#include "jni.h"

namespace Martini { namespace JIE {

    class CJavaClass : public IJavaClass
    {
    public:
        CJavaClass(const unsigned char *pubClassFile, unsigned int uiClassSize);
        virtual ~CJavaClass();

        // IJavaClass methods
        virtual TResult GetName(MIE::SWideString *pClassName) const;
        virtual TResult GetInfo(SJavaClassInfo *pClassInfo) const;
        virtual unsigned int GetNumberOfMethods() const;
        virtual TJavaMethodIterator *GetMethodIterator();
        virtual IJavaField* AddField(
            const MIE::SWideString& szName, EVarType type, 
            unsigned int uiAttributeFlags);
        virtual TConstantPoolIndex RegisterRecorderCallback(
            const MIE::SWideString& szClassName, 
            const MIE::SWideString& szMethodName,
            const MIE::SWideString& szMethodSig);
        virtual TResult GetValueFromCPEntry(
            TConstantPoolIndex cpIndex, 
            SConstantPoolEntryValue* pValue) const;
        virtual TConstantPoolIndex AddEntryToCP(const SConstantPoolEntryValue& value);
        virtual TResult WriteBack(MIE::SBuffer *pBuffer, 
                                  TMemoryAllocatorFunc funcAllocator);
        virtual void Free();

        virtual TJavaFieldIterator *GetFieldIterator();

        virtual IJavaField* AddReferenceField(const MIE::SWideString& szName, 
                                              const MIE::SWideString& szSignature,
                                              int uiAttributeFlags);

        virtual IJavaMethod* AddMethod(const MIE::SWideString& szName,
                                       const MIE::SWideString& szSignature,
                                       unsigned int uiAttributeFlags);

        virtual unsigned int GetNumberOfFields() const;
        
        // Internal methods

        void StaticInitializerEmitted() { m_bShouldEmitStaticInitializer = false; }

        CJClassBuilder* GetBciClassBuilder() { return m_pClassBuilder; }

        CModuleJ* GetBciModule() { return m_pModule; }

    private:
        CJClassBuilder *m_pClassBuilder;        // JIE's class-builder object
        CModuleJ *m_pModule;                    // JIE's module object
        CMethodJ *m_pStaticInitializer;         // class static initializer (<clinit>)
        bool m_bModuleParsed;                   // indicates whether m_pModule was parsed
        CJavaMethods m_lstJavaMethods;          // list of class' methods
        CJavaFields m_lstJavaFields;            // list of class' fields
        bool m_bMethodListCreated;              // indicates whether m_lstJavaMethods was initialized
        bool m_bFieldListCreated;               // indicates whether m_lstJavaFields was initialized
        bool m_bShouldEmitStaticInitializer;    // indicates whether the <clinit> method
                                                // should be emitted during WriteBack

        // create a "Class" entry in the constant pool
        CCPClassInfo* CreateClassConstant(const char *szClassName);

        // initialize a static field
        TResult InitializeStaticField(const CCPFieldrefInfo *fieldRef, 
                                      const SVarValue *initValue);

        // gets a pointer to the class initializer method (<clinit>), creating it if necessary
        CMethodJ* GetStaticInitializerMethod();

        // looks up a method by name
        CMethodJ* LookupMethod(const char *szName);

        // creates a class static initializer
        CMethodJ* CreateClassStaticInitializer();

        // parses the internal module only if necessary
        void ParseInternalModule();

        // init the class' methods list
        void InitMethodList(); 

        // init the class' fields list
        void InitFieldList(); 

        // create a new field
        IJavaField* InternalAddField(u2 uiFlags, const char *szName, CJavaType fieldType);

        // JNI environment pointer for Java 6 StackMap calculation
        JNIEnv* m_pJniEnv;

        // Whether the current thread was actively attached to the JVM during instantiation of 
        // this class
        bool m_isThreadAttached; 

    }; // class CJavaClass

}} // namespace JIE

#endif // #define MRTE_JAVALCLASS

