/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//
#pragma warning (disable:4786)

#include "JavaField.h"
#include "BciUtils.h"

using namespace Martini::JIE;
using namespace Martini::MIE;

//////////////////////////////////////////////////////////////////////////
// class CJavaField implementation

CJavaField::CJavaField(CJavaClass *pOwner, 
                       CFieldInfo *pBciField, 
                       CCPFieldrefInfo *pBciCpFieldRef)
    : m_pBciField(pBciField), m_pBciCpFieldRef(pBciCpFieldRef), m_pOwnerClass(pOwner)
{
}

CJavaField::~CJavaField()
{
}

TResult CJavaField::GetFieldInfo(SJavaFieldInfo* pFieldInfo) const
{
    if (NULL == m_pBciField)
    {
        return MRTE_ERROR_UNEXPECTED;
    }

    // get class name
    TResult res = m_pOwnerClass->GetName(&(pFieldInfo->className));
    if (MRTE_FAILED(res))
    {
        return res;
    }

    // get field name
    res = CBciUtils::CCPUtf8InfoToWideString(pFieldInfo->fieldName, m_pBciField->GetName());
    if (MRTE_FAILED(res))
    {
        return res;
    }

    // get field signature
    res = CBciUtils::CCPUtf8InfoToWideString(pFieldInfo->fieldSignature, 
        m_pBciField->GetDescriptor());
    if (MRTE_FAILED(res))
    {
        return res;
    }

    // get field access flags
    pFieldInfo->uiAttributeFlags = m_pBciField->GetAccessFlags();
    return MRTE_RESULT_OK; 
}

TConstantPoolIndex CJavaField::GetIndex() const
{
    return m_pBciCpFieldRef->GetCpIndex();
}

