/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//
#ifndef MRTE_JAVAFIELD
#define MRTE_JAVAFIELD

#include "JavaClass.h"
#include "JIE.h"

namespace Martini { namespace JIE {

class CJavaField : public IJavaField
{
public:
	CJavaField(CJavaClass *pOwner, CFieldInfo *pBciField, CCPFieldrefInfo *pBciCpFieldRef);
	virtual ~CJavaField();

    // IJavaField interface methods
    virtual TResult GetFieldInfo(SJavaFieldInfo* pFieldInfo) const;
    virtual TConstantPoolIndex GetIndex() const;

private:
    CJavaClass *m_pOwnerClass;          // the CJavaClass object to which this field belongs
    CFieldInfo *m_pBciField;            // internal BCI field object
    CCPFieldrefInfo *m_pBciCpFieldRef;  // internal BCI constant-pool field reference
};

}}

#endif // MRTE_JAVAFIELD
