/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//
#ifndef MRTE_JAVAMETHOD
#define MRTE_JAVAMETHOD

#include "JavaClass.h"
#include "JIE.h"
#include "ModuleJ.h"
#include "MethodInstrumentor.h"

namespace Martini { namespace JIE {

class CJavaMethod : public IJavaMethod  
{
public:
	CJavaMethod(CJavaClass *pOwner, CMethodJ *pmethj);
	virtual ~CJavaMethod();

    // IMethod interface methods
    virtual MIE::TInstructionListIterator *GetInstructionListIterator(
        const MIE::EInstructionIteratorType iteratorType);
    virtual TResult BindTryFinallyBlock(MIE::IInstruction* iTry, 
                                        MIE::IInstruction* iEndTry, 
                                        MIE::IInstruction* iFinally, 
                                        MIE::IInstruction* iEndFinally);
    virtual TResult VerifyCode(MIE::SInstrumentationErrorsArray* pErrorsArray = NULL) const;
    virtual TResult ApplyInstrumentation();
    virtual TResult DebugPrint(bool bToResolveNames, char* fileName = NULL);

    // IJavaMethod interface methods
    virtual TResult GetMethodInfo(SJavaMethodInfo* pMethodInfo) const;
    virtual TResult AddLocalVariable(MIE::TVariableID *pVariableId, 
                                     EVarType variableType);
    virtual TConstantPoolIndex GetIndex() const;

    // Internal methods
    CMethodJ* GetBciMethod() { return m_pBCIMethod; }

private:
    CMethodJ *m_pBCIMethod;     // internal BCI CMethodJ object
    MIE::CMethodInstrumentor m_instrumentor;
    CJavaClass *m_pOwnerClass;  // the CJavaClass object to which this method belongs

    bool IsStaticInitializer() const;
    
    bool _AddLocalVariable(CCodeAttribute *pCodeAttr, const CJavaType &jtType,
                           u2 &varIndex);
};

}}

#endif // MRTE_JAVAMETHOD
