/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//

#ifndef MRTE_MIEINSTRUCTIONCODEC
#define MRTE_MIEINSTRUCTIONCODEC

#include "MRTETypes.h"
#include "FlowGraph.h"
#include "MethodInstrumentor.h"

namespace Martini { namespace MIE {

class IMIEInstructionCodec
{
public:
    virtual ~IMIEInstructionCodec() {}

    virtual TResult Decode(CFlowGraph *pFlowGraph) = 0;
    virtual TResult Encode(CFlowGraph &flowGraph) = 0;
    virtual TResult Init(CMethodInstrumentor *pInstrumentor)
    {
        m_pInstrumentor = pInstrumentor;
        return MRTE_RESULT_OK;
    }
    
protected:
    CMethodInstrumentor *m_pInstrumentor;
};

}}

#endif // MRTE_MIEINSTRUCTIONCODEC

