/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//

#include "MIEInstructionFactory.h"
#include "ValidityChecks.h"
#include "MethodInstrumentor.h"

#define DEF_FACTORY(op, mnem, sem, opCount) \
        CMIEInstructionDescr((EMnemonic)op, #mnem, sem, opCount),

#define SIZE_OF_ARRAY(x) sizeof(x)/sizeof(*x)

using namespace Martini::MIE;

static CMIEInstructionDescr MIEInsDescrList[] = 
{
    #include "MIEInsFactoryMap.def"
};

//////////////////////////////////////////////////////////////////////////
// class CMIEInstructionDescr implementation

CMIEInstruction* CMIEInstructionDescr::CreateInstruction(CMethodInstrumentor* pInstrumentor)
{
    CMIEInstruction *pNewInst = new CMIEInstruction(pInstrumentor);
    Init(pNewInst);
    return pNewInst;
}

void CMIEInstructionDescr::Init(CMIEInstruction *pInst)
{
    pInst->m_mnem = m_opCode;
    pInst->SetName(m_szName);
    pInst->SetSemantics(m_sem);
    pInst->SetStatus(CMIEInstruction::IS_NEW); // default for new instructions
    pInst->AllocateOperands(m_uiOpCount);
}


//////////////////////////////////////////////////////////////////////////
// class CMIEInstructionFactory implementation

// static members initialization
/*
bool CMIEInstructionFactory::sm_bInitialized = false;
CMIEInstructionDescr **CMIEInstructionFactory::sm_vInsDescrList = NULL;
unsigned int CMIEInstructionFactory::sm_uiDescrCount = 0;
*/

CMIEInstructionFactory::CMIEInstructionFactory()
{

}

CMIEInstructionFactory::~CMIEInstructionFactory()
{

}

CMIEInstruction* CMIEInstructionFactory::CreateInstruction(
    unsigned int opcode,
    CMethodInstrumentor *pInstrumentor)
{
/*
    if (!sm_bInitialized)
    {
        Init();
        sm_bInitialized = true;
    }
*/
    // look-up the instruction descriptor according to the opcode and use it
    // to create the correct instruction object
    CMIEInstructionDescr &instDescr = MIEInsDescrList[opcode];
    //CHECK_RETURN_NULL(pInstDescr);
    CMIEInstruction *pNewInst = instDescr.CreateInstruction(pInstrumentor);
    if (pNewInst->IsPseudo() && NULL != pInstrumentor)
    {
        pNewInst->SetLabel(pInstrumentor->GetUniqueLabel());
    }
    return pNewInst;
}

CMIEInstructionDescr& CMIEInstructionFactory::GetDescriptor(unsigned int opcode)
{
/*
    if (!sm_bInitialized)
    {
        Init();
        sm_bInitialized = true;
    }
*/
    return MIEInsDescrList[opcode];
}


void CMIEInstructionFactory::Free()
{
    //TODO: remove?
/*
    if (sm_bInitialized)
    {
        delete [] sm_vInsDescrList;
    }
    sm_bInitialized = false;
*/
}

void CMIEInstructionFactory::Init()
{
    // initialize instruction descriptors table
/*
    sm_uiDescrCount = SIZE_OF_ARRAY(MIEInsDescrList);
    sm_vInsDescrList = new CMIEInstructionDescr*[sm_uiDescrCount];
    unsigned int i;
    for (i = 0; i < sm_uiDescrCount; ++i)
    {
        sm_vInsDescrList[i] = &MIEInsDescrList[i];
    }
*/
}

