/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//

#ifndef MRTE_MIEINSTRUCTIONFACTORY
#define MRTE_MIEINSTRUCTIONFACTORY

#include "MIEInstruction.h"
#include "MieAPI.h"

namespace Martini { namespace MIE {

class CMIEInstructionDescr
{
public:
    CMIEInstructionDescr(EMnemonic opcode, const char *szMnem, 
        CMIEInstruction::ESemanticTag semTag, unsigned int opCount) : m_opCode(opcode),
        m_szName(szMnem), m_sem(semTag), m_uiOpCount(opCount) {}
    virtual CMIEInstruction* CreateInstruction(CMethodInstrumentor* pInstrumentor = NULL);
    EMnemonic GetOpcode() { return m_opCode; }
    const char* const GetName() const { return m_szName; }
    CMIEInstruction::ESemanticTag GetSemantics() {return m_sem; }
    unsigned int GetOpCount() { return m_uiOpCount; }

protected:
    EMnemonic m_opCode;
    const char *m_szName;
    CMIEInstruction::ESemanticTag m_sem;
    unsigned int m_uiOpCount;

    void Init(CMIEInstruction *pInst);

};

/*
//TODO: remove?
class CMIEBranchDescr : public CMIEInstructionDescr
{
public:
    CMIEBranchDescr(EMnemonic opcode, const char *szMnem, 
        CMIEInstruction::ESemanticTag semTag) : 
        CMIEInstructionDescr(opcode, szMnem, semTag) {}
    CMIEInstruction* CreateInstruction(CMethodInstrumentor* pInstrumentor = NULL);
};

class CMIESwitchDescr : public CMIEInstructionDescr
{
public:
    CMIESwitchDescr(EMnemonic opcode, const char *szMnem, 
        CMIEInstruction::ESemanticTag semTag) : 
        CMIEInstructionDescr(opcode, szMnem, semTag) {}
    CMIEInstruction* CreateInstruction(CMethodInstrumentor* pInstrumentor = NULL);
};

class CMIEPseudoDescr : public CMIEInstructionDescr
{
public:
    CMIEPseudoDescr(EMnemonic opcode, const char *szMnem, 
        CMIEInstruction::ESemanticTag semTag) : 
        CMIEInstructionDescr(opcode, szMnem, semTag) {}
    CMIEInstruction* CreateInstruction(CMethodInstrumentor* pInstrumentor = NULL);
};
*/

class CMIEInstructionFactory  
{
public:
	virtual ~CMIEInstructionFactory();
    static CMIEInstruction* CreateInstruction(
        unsigned int opcode,
        CMethodInstrumentor *pInstrumentor = NULL);
    static void Free();
    static CMIEInstructionDescr& GetDescriptor(unsigned int opcode);

protected:
    // protected constructor to prevent instantiation
	CMIEInstructionFactory();

private:
/*
    static CMIEInstructionDescr **sm_vInsDescrList;
    static unsigned int sm_uiDescrCount;
    static bool sm_bInitialized;

*/
    static void Init();
};

}}

#endif // MRTE_MIEINSTRUCTIONFACTORY
