/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//

#ifndef MRTE_MIEPROTECTEDBLOCK
#define MRTE_MIEPROTECTEDBLOCK

#include "MieAPI.h"

namespace Martini { namespace MIE {

class CMIEProtectedBlock  
{
public:
    enum EProtectedBlockType
    {
            PBT_NONE = 0,               // no protected block
            PBT_JAVA_EXCEPTION,         // Try..Catch/Try..Finally block (Java only)
            PBT_TRY_CATCH,              // Try..Catch block (.NET only)
            PBT_TRY_FAULT,              // Try..Fault block (.NET only)
            PBT_TRY_FILTER,             // Try..Filter block (.NET only)
            PBT_TRY_FINALLY,            // Try..Finally block (.NET only)
            PBT_LAST                    // no protected block type is greater than this
    };

    CMIEProtectedBlock();
	virtual ~CMIEProtectedBlock();

    EProtectedBlockType     type;                   // block type
	unsigned int            uiTryStartOffset;       // offset at which the protected block begins (inclusive)
	unsigned int            uiTryEndOffset;         // offset at which the protected block ends (inclusive)
	unsigned int            uiHandlerStartOffset;   // offset at which the handler begins
	unsigned int            uiHandlerEndOffset;     // offset at which the handler ends (.NET only - inclusive)
	unsigned int            uiHandlerType;          // the Exception type being handled
                                                    // (CP index in Java, token in .NET)
                                                    // Java only: 0 means "catch all" and is used
                                                    // for implementing "finally" blocks
}; // CMIEProtectedBlock

}}

#endif // MRTE_MIEPROTECTEDBLOCK
