/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//

#ifndef MRTE_METHODINSTRUMENTOR
#define MRTE_METHODINSTRUMENTOR

#include "MRTETypes.h"
#include "FlowGraph.h"
#include "FlowGraphNode.h"

namespace Martini { namespace MIE {

class IMIEInstructionCodec;     // forward declaration

class CMethodInstrumentor  
{
public:
	CMethodInstrumentor();
	virtual ~CMethodInstrumentor();

    TResult Init(IMIEInstructionCodec *pInstructionCodec);
    TResult AddInstructionBefore(CMIEInstruction   **ppInstruction,
                                 CFlowGraphNode *pfgNode,
                                 const EMnemonic newInstMnemonic,
                                 const SOperand *pNewInstOperand1,
                                 const SOperand *pNewInstOperand2,
                                 const SOperand *pNewInstOperand3);
    TResult AddInstructionAfter(CMIEInstruction   **ppInstruction,
                                CFlowGraphNode *pfgNode,
                                const EMnemonic newInstMnemonic,
                                const SOperand *pNewInstOperand1,
                                const SOperand *pNewInstOperand2,
                                const SOperand *pNewInstOperand3);
    TResult ApplyInstrumentation();
    TInstructionListIterator* GetInstructionListIterator(EInstructionIteratorType type);
    CFlowGraph& GetFlowGraph() { return m_flowGraph; }
    TResult BindTryFinallyBlock(CMIEInstruction* pTry, 
                                CMIEInstruction* pEndTry, 
                                CMIEInstruction* pFinally, 
                                CMIEInstruction* pEndFinally);
    unsigned int GetUniqueLabel() { return m_uiNextLabel++; }

private:
    CFlowGraph m_flowGraph;
    IMIEInstructionCodec *m_pCodec;
    bool m_bFlowGraphInitialized;   // specifies whether the flow-graph was initialized
    unsigned int m_uiNextLabel;     // a unique label to be assigned to a pseudo-instruction

    TResult ValidateTryFinallyBlockInstOrder(CMIEInstruction* pTry, 
                                             CMIEInstruction* pEndTry, 
                                             CMIEInstruction* pFinally, 
                                             CMIEInstruction* pEndFinally);
    CMIEInstruction* FindRealInstBefore(CMIEInstruction *pInst);
    CMIEInstruction* FindRealInstAfter(CMIEInstruction *pInst);

};

}}

#endif // MRTE_METHODINSTRUMENTOR
