/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef _MRTE_OPCODES
#define _MRTE_OPCODES

#define nop                 0x00
#define iconst_0            0x03
#define iconst_1            0x04
#define iconst_2            0x05
#define iconst_3            0x06
#define iconst_4            0x07
#define iconst_5            0x08

#define sipush              0x11
#define ldc					0x12
#define ldc_w				0x13
#define ldc2_w				0x14

#define iload				0x15
#define lload				0x16
#define fload				0x17
#define dload				0x18
#define aload				0x19
#define iload_0				0x1a
#define iload_1				0x1b
#define iload_2				0x1c
#define iload_3				0x1d
#define lload_0				0x1e
#define lload_1				0x1f
#define lload_2				0x20
#define lload_3				0x21
#define fload_0				0x22
#define fload_1				0x23
#define fload_2				0x24
#define fload_3				0x25
#define dload_0				0x26
#define dload_1				0x27
#define dload_2				0x28
#define dload_3				0x29
#define aload_0				0x2a
#define aload_1				0x2b
#define aload_2				0x2c
#define aload_3				0x2d
#define iaload				0x2e
#define laload				0x2f
#define faload				0x30
#define daload				0x31
#define aaload				0x32
#define baload				0x33
#define caload				0x34
#define saload				0x35

#define istore				0x36
#define lstore				0x37
#define fstore				0x38
#define dstore				0x39
#define astore				0x3a
#define istore_0			0x3b
#define istore_1			0x3c
#define istore_2			0x3d
#define istore_3			0x3e
#define lstore_0			0x3f
#define lstore_1			0x40
#define lstore_2			0x41
#define lstore_3			0x42
#define fstore_0			0x43
#define fstore_1			0x44
#define fstore_2			0x45
#define fstore_3			0x46
#define dstore_0			0x47
#define dstore_1			0x48
#define dstore_2			0x49
#define dstore_3			0x4a
#define astore_0			0x4b
#define astore_1			0x4c
#define astore_2			0x4d
#define astore_3			0x4e
#define iastore				0x4f
#define lastore				0x50
#define fastore				0x51
#define dastore				0x52
#define aastore				0x53
#define bastore				0x54
#define castore				0x55
#define sastore				0x56

#define ifeq                0x99
#define ifne                0x9a
#define iflt                0x9b
#define ifge                0x9c
#define ifgt                0x9d
#define ifle                0x9e
#define if_icmpeq           0x9f
#define if_icmpne           0xa0
#define if_icmplt           0xa1
#define if_icmpge           0xa2
#define if_icmpgt           0xa3
#define if_icmple           0xa4

#define _goto				0xa7

#define ireturn				0xac
#define lreturn				0xad
#define freturn				0xae
#define dreturn				0xaf
#define areturn				0xb0
#define _return				0xb1

#define getstatic           0xb2
#define putstatic           0xb3

#define invokevirtual		0xb6
#define invokespecial		0xb7
#define invokestatic		0xb8
#define invokeinterface		0xb9

#define athrow				0xbf

#define goto_w				0xc9

#endif


