/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
#ifdef EM64T_ARCH
#pragma runtime_checks( "", off )
#endif

#include "DataManagerEvents.h"
#include "EventManager.h"
#include "JPI.H"
#include "LogAssert.h"
#include "JpiGlobals.h"

using namespace Martini::MPI;
using namespace Martini::JPI;
using namespace Martini::Infrastructure;

//////////////////////////////////////////////////////////////////////////
// Class Prepare event observer

CClassPrepareEventObserver::CClassPrepareEventObserver(CDataManager *pDM)
{
    m_pDM = pDM;
}

void CClassPrepareEventObserver::HandleEvent(SEmData *pEvent, void *userData)
{
    m_pDM->ClassPrepareHandler(pEvent);
}

//////////////////////////////////////////////////////////////////////////
// EV_JITTED_METHOD_LOADED
CMethodJitEventObserver::CMethodJitEventObserver(CDataManager *pDM)
{
    m_pDM = pDM;
}

void CMethodJitEventObserver::HandleEvent(SEmData *pEvent, void *pUserData)
{
    TId methodId = 0; 
    
    jmethodID jvmMethodId = pEvent->u.pJVMData->u.methodLoad.methodId;
    TResult iRetVal = m_pDM->GetMpiMethodIdWModuleId(jvmMethodId, &methodId, NULL, NULL, true);
    if (MRTE_SUCCEEDED(iRetVal))
    {
        iRetVal = m_pDM->SetMethodJitted(methodId);
        if (MRTE_FAILED(iRetVal))
        {
            MARTINI_INFORMATIVE1("CMethodJitEvent", 0 ,false, 
                "Failed to set method as jitted - Method: 0x%08X", methodId);
        }
    }
}

//////////////////////////////////////////////////////////////////////////
// EV_THREAD_START
CThreadStartEventObserver::CThreadStartEventObserver(CDataManager *pDM)
: m_pDM(pDM)
{
}

void CThreadStartEventObserver::HandleEvent(SEmData *pEvent, void *pUserData)
{
    TId threadId;
    m_pDM->GetThreadInfoManager()->ThreadStart(&threadId, 
        pEvent->u.pJVMData->u.threadStart.pThreadEnv,
        pEvent->u.pJVMData->u.threadStart.threadLocalRef,
        false, /* do not generate EV_THREAD_START - obviously it was already generated */
        pEvent->u.pJVMData->u.threadStart.szName,
        pEvent->u.pJVMData->u.threadStart.szGroupName,
        pEvent->u.pJVMData->u.threadStart.szParentGroupName);
}

//////////////////////////////////////////////////////////////////////////
// EV_THREAD_END
CThreadEndEventObserver::CThreadEndEventObserver(CDataManager *pDM)
: m_pDM(pDM)
{
}

void CThreadEndEventObserver::HandleEvent(SEmData *pEvent, void *pUserData)
{
    m_pDM->GetThreadInfoManager()->ThreadEnd(pEvent->u.pJVMData->u.threadEnd.pThreadEnv);
}

//////////////////////////////////////////////////////////////////////////
// EV_VM_INIT
CDMVMInitEventObserver::CDMVMInitEventObserver(CDataManager *pDM)
: m_pDM(pDM)
{
}

void CDMVMInitEventObserver::HandleEvent(SEmData *pEvent, void *pUserData)
{
    CJpiGlobals::Instance()->bJvmInitDone = true;
    m_pDM->GetThreadInfoManager()->UpdateInfo();
}

//////////////////////////////////////////////////////////////////////////
// EV_VM_SHUTDOWN
CDMVMShutdownEventObserver::CDMVMShutdownEventObserver(CDataManager *pDM)
: m_pDM(pDM)
{
}

void CDMVMShutdownEventObserver::HandleEvent(SEmData *pEvent, void *pUserData)
{
#ifdef DEBUG_STAT
    m_pDM->PrintDebugStatistics();
#endif
    m_pDM->GetThreadInfoManager()->VmShutDown();
}


//////////////////////////////////////////////////////////////////////////
// EV_GC_END
CDMGCStartEventObserver::CDMGCStartEventObserver(CDataManager *pDM)
: m_pDM(pDM)
{
}

void CDMGCStartEventObserver::HandleEvent(SEmData *pEvent, void *pUserData)
{
    m_pDM->GetObjectInfoManager()->IncrementGcCounter();
}
