/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef _MRTE_DATA_MANAGER_EVENTS_H
#define _MRTE_DATA_MANAGER_EVENTS_H

#include "MpiAPI.h"
#include "JpiEvent.h"
#include "MHash.h"

namespace Martini { namespace JPI
{
    class CDataManager;

    class CClassPrepareEventObserver : public IInternalEventObserver
    {
    public:
        CClassPrepareEventObserver(CDataManager *pDM);
        MPI::TEventType Type() { return Infrastructure::EM_EVENT_INTERNAL_CLASS_PREPARE; }
        void HandleEvent(SEmData *pEvent, void *pUserData);    
    private:
        CDataManager *m_pDM;
        
    };

    class CMethodJitEventObserver : public IInternalEventObserver
    {
    public:
        CMethodJitEventObserver(CDataManager *pDM);
        void HandleEvent(SEmData *pEvent, void *pUserData); 
        MPI::TEventType Type() { return MPI::EV_JITTED_METHOD_LOADED; }
        virtual Infrastructure::EEventPriority GetPriority() 
        {
            return Infrastructure::EVENT_PRIORITY_HIGH;
        }
    private:
        CDataManager *m_pDM;
    };

    class CThreadStartEventObserver : public IInternalEventObserver
    {
    public:
        CThreadStartEventObserver(CDataManager *pDM);
        void HandleEvent(SEmData *pEvent, void *pUserData); 
        MPI::TEventType Type() { return MPI::EV_THREAD_START; }
        virtual Infrastructure::EEventPriority GetPriority() 
        {
            // Internal Thread Start event handler must be called before any
            // profiler's handler, because the internal handler is responsible for
            // updating the threads database
            return Infrastructure::EVENT_PRIORITY_HIGH;
        }
    private:
        CDataManager *m_pDM;
    };
    
    class CThreadEndEventObserver : public IInternalEventObserver
    {
    public:
        CThreadEndEventObserver(CDataManager *pDM);
        void HandleEvent(SEmData *pEvent, void *pUserData); 
        MPI::TEventType Type() { return MPI::EV_THREAD_END; }
        virtual Infrastructure::EEventPriority GetPriority() 
        {
            // Internal Thread End event handler must be called after any
            // profiler's handler, because it removes the association between a JNI
            // environment and its thread id.
            return Infrastructure::EVENT_PRIORITY_LOW;
        }
    private:
        CDataManager *m_pDM;
    };

    class CDMVMInitEventObserver : public IInternalEventObserver
    {
    public:
        CDMVMInitEventObserver(CDataManager *pDM);
        void HandleEvent(SEmData *pEvent, void *pUserData); 
        MPI::TEventType Type() { return MPI::EV_VM_INIT; }
        virtual Infrastructure::EEventPriority GetPriority() 
        {
            // Internal VM Init event handler must be called before any
            // profiler's handler
            return Infrastructure::EVENT_PRIORITY_HIGH;
        }
    private:
        CDataManager *m_pDM;
    };

    class CDMVMShutdownEventObserver : public IInternalEventObserver
    {
    public:
        CDMVMShutdownEventObserver(CDataManager *pDM);
        void HandleEvent(SEmData *pEvent, void *pUserData); 
        MPI::TEventType Type() { return MPI::EV_VM_SHUTDOWN; }
        virtual Infrastructure::EEventPriority GetPriority() 
        {
            // Internal VM Shutdown event handler must be called before any
            // profiler's handler
            return Infrastructure::EVENT_PRIORITY_HIGH;
        }
    private:
        CDataManager *m_pDM;
    };

    class CDMGCStartEventObserver : public IInternalEventObserver
    {
    public:
        CDMGCStartEventObserver(CDataManager *pDM);
        void HandleEvent(SEmData *pEvent, void *pUserData); 
        MPI::TEventType Type() { return MPI::EV_GC_START; }
        virtual Infrastructure::EEventPriority GetPriority() 
        {
            // Internal GC Start event handler must be called before any
            // profiler's handler
            return Infrastructure::EVENT_PRIORITY_HIGH;
        }
    private:
        CDataManager *m_pDM;
    };


#if 0
    typedef Intel::Bistro::Martini::RTUtil::MHashSync<UIOP, SDMObjectInfo*> TObjectInfoDB;

    class CObjectAllocEvent : public CJpiEvent
    {
    public:
        CObjectAllocEvent(unsigned int dataRequest);
        TResult HandleStdPIEvent(SEmData *pEvent, void *userData); 
        TObjectInfoDB *GetDatabase() {return m_pObjectDatabase;};
        MPI::CUserData *GetObjectUserData(UIOP objectId);
        Infrastructure::EEventPriority GetPriority() 
                                                {return Infrastructure::EVENT_PRIORITY_HIGH;};
    private:
        TObjectInfoDB *m_pObjectDatabase;
        MPI::EArrayType m_StdPiType2MpiArrayType[MAX_STD_ARRAY_TYPES];
    };

    class CObjectFreeEvent : public CJpiEvent
    {
    public:
        CObjectFreeEvent(unsigned int dataRequest, CObjectAllocEvent *pObjAllocEvent);
        TResult HandleStdPIEvent(SEmData *pEvent, void *userData); 
        Infrastructure::EEventPriority GetPriority() 
                                                {return Infrastructure::EVENT_PRIORITY_LOW;};
    private:
        CObjectAllocEvent *m_pObjectAllocEvent;
        TObjectInfoDB *m_pObjectDatabase;
    };

    class CObjectMoveEvent : public CJpiEvent
    {
    public:
        CObjectMoveEvent(unsigned int dataRequest, CObjectAllocEvent *pObjAllocEvent);
        TResult HandleStdPIEvent(SEmData *pEvent, void *userData);    
    private:
        CObjectAllocEvent *m_pObjectAllocEvent;
        TObjectInfoDB *m_pObjectDatabase;
    };
#endif
}}

#endif

