/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
#ifdef EM64T_ARCH
#pragma runtime_checks( "", off )
#endif

#include "JIMEvents.h"
#include "JavaInstrumentorManager.h"

using namespace Martini::MPI;
using namespace Martini::JPI;

//////////////////////////////////////////////////////////////////////
// CClassLoadHookEvent implementation

CClassLoadHookEventObserver::~CClassLoadHookEventObserver()
{
}

CClassLoadHookEventObserver::CClassLoadHookEventObserver(CJavaInstrumentorManager *pJIM)
{
    m_pJIM = pJIM;
}

void CClassLoadHookEventObserver::HandleEvent(SEmData *pEvent, void *pUserData)
{
    m_pJIM->InstrumentationEventHandler(pEvent);
}

//////////////////////////////////////////////////////////////////////
// CJVMInitEvent implementation

CJVMInitEventObserver::~CJVMInitEventObserver()
{
}

CJVMInitEventObserver::CJVMInitEventObserver(CJavaInstrumentorManager *pJIM)
{
    m_pJIM = pJIM;
}

void CJVMInitEventObserver::HandleEvent(SEmData *pEvent, void *pUserData)
{
    m_pJIM->JVMInitEventHandler();
}
