/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef _MRTE_JIM_EVENTS_H
#define _MRTE_JIM_EVENTS_H

#include "JpiEvent.h"

namespace Martini { namespace JPI
{
    class CJavaInstrumentorManager;
    
    //
    // Class File Load Hook event handler
    //
    class CClassLoadHookEventObserver : public IInternalEventObserver
    {
    public:
        CClassLoadHookEventObserver(CJavaInstrumentorManager *pJIM);
	    virtual ~CClassLoadHookEventObserver();
        void HandleEvent(struct SEmData *pEvent, void *pUserData);
        MPI::TEventType Type() { return MPI::EV_JAVA_CLASS_FILE_LOAD_HOOK; }
    
    private:
        CJavaInstrumentorManager *m_pJIM;
    };

    //
    // JVM Init event handler
    //
    class CJVMInitEventObserver : public IInternalEventObserver
    {
    public:
        CJVMInitEventObserver(CJavaInstrumentorManager *pJIM);
        virtual ~CJVMInitEventObserver();
        void HandleEvent(SEmData *pEvent, void *pUserData);
        MPI::TEventType Type() { return MPI::EV_VM_INIT; }

    private:
        CJavaInstrumentorManager *m_pJIM;
    };

}}

#endif 

