/*****************************************************************************
 * Copyright (c) 1997, 2009 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
#ifdef EM64T_ARCH
#pragma runtime_checks( "", off )
#endif

#include "JPI.H"
#include "JPIKernel.h"
#include "JpiGlobals.h"
#include <stdio.h>

using namespace Martini::JPI;
using namespace Martini::MPI;
using namespace Martini::MIE;
using namespace Martini::Infrastructure;

//////////////////////////////////////////////////////////////////////////
// CJpiInterface implementation

CJpiInterface::CJpiInterface(ERuntimeType iRuntimeType, IDataManager *pDataManager, 
                             IEventManager *pEventManager, IKernel *pKernel, 
                             CECAgent* pECAgent, CLogger* pLogger)
: CMpiInterface(iRuntimeType, pDataManager, pEventManager, pKernel, pECAgent, pLogger)
{
}

IMIE* CJpiInterface::GetInstrumentor()
{
    // Not implemented for JPI in this slice
    return NULL;
}


//////////////////////////////////////////////////////////////////////////
// External functions

extern "C" 
JPI_API int JPI_Initialize(JavaVM *pVM, char *szOptions, EJVMInterfaceType jvmInterfaceType)
{
    CJPIKernel *pJPIKernel = CJPIKernel::GetJPIKernel();
    if (pJPIKernel)
    {
        TResult retVal = pJPIKernel->Initialize(pVM, szOptions, jvmInterfaceType);
        if (MRTE_SUCCEEDED(retVal))
        {
            return 0;
        }
    }
    JPI_WARNING("Unable to initialize JPI. Exiting...", 0);
    return 1;
}

extern "C"
JPI_API TResult JPI_AttachCurrentThread(JNIEnv **ppJNIEnv, bool *bAttached)
{
    IJVM *pJvmInterface = CJpiGlobals::Instance()->pJvmInterface;
    if (NULL == pJvmInterface)
    {
        return MRTE_ERROR_PHASE_FAILURE;
    }
    return pJvmInterface->AttachCurrentThread(ppJNIEnv, bAttached);
}


extern "C"
JPI_API void JPI_DetachCurrentThread()
{
    IJVM *pJvmInterface = CJpiGlobals::Instance()->pJvmInterface;
    if (pJvmInterface)
    {
        pJvmInterface->DetachCurrentThread();
    }
}
