/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef _MRTE_JPI_KERNEL_H
#define _MRTE_JPI_KERNEL_H

#include "MpiAPI.h"
#include "MPI.h"
#include "EventManager.h"
#include "DataManager.h"
#include "JavaInstrumentorManager.h"
#include "ParamChecker.h"
#include "MRTEInfrastructureDefinitions.h"
#include "JPI.H"
#include "IJVM.h"
#include "MString.h"
#include "ECAgent.h"
#include "LogAssert.h"
#include "IKernel.h"
#include "BootLoaderOptionParser.h"


namespace Martini { namespace JPI
{

    /**
     * @class CJPIKernel
     * JPI Kernel. Initializes JPI, EC module and profilers
     */
    class CJPIKernel : public Infrastructure::IKernel
    {
    public:
            
        static CJPIKernel *GetJPIKernel() ;

        // IKernel methods

        virtual TResult InstantiateClient(MPI::TId clientId, 
                                          const char *szRequestedModuleName,
                                          const char *szOptions);
        virtual Infrastructure::SClientInfo *GetClientInfo(MPI::TId id);
        virtual Infrastructure::SClientInfo *GetClientInfo(const char* szClientName);
        virtual TResult Configure(MPI::BitSet configuration);
        virtual TResult SuspendVM();
        virtual TResult ResumeVM();
        virtual TResult RunGC();
        virtual TResult GenerateObjectAllocEventForLiveObjects(MPI::TId clientId);

        // CJPIKernel methods

        TResult Initialize(JavaVM *pVM, char *szOptions, EJVMInterfaceType jvmInterfaceType);
        unsigned int GetNumClients() { return m_nextId; };

    private:
        TResult IdAllocate(MPI::TId *pId);
        TResult LoadProfilers(const Infrastructure::TModuleSpecList &lstProfilerSpecs);
        TResult LoadProfiler(const char *szProfilerName, const char *szProfilerOptions);

        CJPIKernel(void);
        ~CJPIKernel(void);
        
        // module id
        MPI::TId m_ModuleId;

        // an array that holds all clients' information (name, external control callbacks).
        // The index to the array is the client_id
        Infrastructure::SClientInfo m_vClientInfo[EM_MAX_CLIENTS];
        
        // next available client id
        MPI::TId m_nextId;
        
        // a pointer to the event manager
        CEventManager *m_pEventManager;
        
        // a pointer to the data manager
        CDataManager  *m_pDataManager;

        // a pointer to the external control agent
        Infrastructure::CECAgent *m_pECAgent;
        
        // a pointer to the Java Instrumentor Manager
        CJavaInstrumentorManager *m_pJavaInstrumentorManager;
        
        // a pointer to the MPI interface
        MPI::CMpiInterface *m_pMpiInterface;
        
        // a pointer to the param checker
        Infrastructure::CParamChecker *m_pParamChecker;
        
        // a static pointer to the singleton kernel
        static CJPIKernel *pThis;

        // flag indicating if we are in init phase
        bool m_bInitPhaseCompleted;

        //  JVM interface
        IJVM *m_pJVMInterface;

        Infrastructure::CLogAssert* m_pLogAssert;

    };
}}


#endif


