/*****************************************************************************
 * Copyright (c) 1997, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef MRTE_JVMPI_INTERFACE_H
#define MRTE_JVMPI_INTERFACE_H


#include "IJVM.h"
#include "jvmpi.h"
#include "MRTEInfrastructureDefinitions.h"
#include "EventManager.h"

namespace Martini { namespace JPI
{

/**
 * @class CTICapabilityFactory
 * 
 * @brief Factory for JVMPI capabilities
 */
class CPICapabilityFactory : public ICapabilityFactory
{
public:
    CPICapabilityFactory() {}
    virtual ICapability* CreateCapability(ECapabilityType cap);
};

/**
 * @class CJVMPIInterface
 * 
 * @brief JVM interface implementation for JVMPI (J2SE 1.4.x).
 */
class CJVMPIInterface : public IJVM  
{
    public:
	    CJVMPIInterface();
	    virtual ~CJVMPIInterface();
        TResult Initialize(MPI::TId moduleId, JavaVM *pJVM);
        void ProfilerExit();
        TResult RegisterEvent(MPI::TEventType mpiEvent);
        TResult RequestClassLoadEvent(UIOP classId);
        MPI::TEventType GetMpiEvent(jint jvmpiEvent) {return m_vJVMPI2MpiEvents[jvmpiEvent];};
        bool CanSupplyClassLoadHookToAllClasses();
        TResult DisableEvent(MPI::TEventType mpiEvent);
        virtual TResult EnableEvent(MPI::TEventType mpiEvent);
        TResult GetJNIEnv(JNIEnv **ppJNIEnv);
        virtual EInterfaceType GetInterfaceType();
        virtual TResult GetCurrentThreadCpuTime(MPI::TTimeStamp *pCpu);

        TResult RedefineClasses(jint classCount, const jvmtiClassDefinition* classDefinitions)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }

        virtual TMemoryAllocatorFunc GetMemoryAllocator()
        {
            // not supported under JVMPI
            return NULL;
        }

        virtual jclass FindClass(const char *szClassName)
        {
            return NULL;
        }

        virtual TResult GetThreadInfo(MPI::SThreadInfo *pThreadInfo, jthread thread)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }
        
        virtual TResult SuspendThread(jthread thread)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }
        
        virtual TResult ResumeThread(jthread thread)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }
        
        virtual TResult SetClassTag(jclass cls)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }
        
        virtual TResult SetObjectTag(jobject obj, jlong tag)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }

        virtual TResult GetObjectTag(jlong *pTag, jobject obj)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }
        
        virtual TResult GetObjectInfo(MPI::SObjectInfo *pObjectInfo, jobject obj)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }

        virtual TResult GetObjectInfoFromTags(TTagVector &inTagVector, 
                                              TObjectInfoVector *pOutInfoVector,
                                              TTagVector *pOutTagVector)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }

        virtual TResult GetObjectClassName(RTUtil::MCString &className, jobject obj)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }

        virtual TResult GetObjectReferences(MPI::SObjectReferenceInfo *pData,
                                            TTagVector *pTagVector)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }

        virtual TResult GetMonitorUsage(MPI::TId *pOwnerThreadId,
                                        MPI::TIdArray *pOwnWaiters,
                                        MPI::TIdArray *pNotifyWaiters,
                                        MPI::BitSet dataItems, 
                                        jobject monitorJniRef)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }

        virtual TResult GetStackTrace(jvmtiFrameInfo *pFrameBuffer, 
                                      jint *pFrameCount, 
                                      jthread thread, 
                                      jint startDepth, 
                                      jint maxFrameCount)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }

        virtual TResult GetMethodInfo(RTUtil::MCString &name,
                                      RTUtil::MCString &sig,
                                      RTUtil::MCString &generic,
                                      jint *pAccessFlags,
                                      MPI::SMethodLineNumbers *pLineNumbers,
                                      jmethodID jvmMethodId)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }

        virtual TResult GetMethodDeclaringClassName(RTUtil::MCString &className,
                                                    MPI::TId *pClassLoaderObjectId,
                                                    jmethodID jvmMethodId)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }
        virtual TResult GetLineNumberTable(MPI::SLineNumberTable *pLineNumberTable,
                                           jmethodID jvmMethodId)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }
        virtual TResult GetThreadState(jint *pState, jthread thread)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }
        virtual TResult GetCurrentContendedMonitor(jobject *pMonObj, jthread thread)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }
        virtual TResult GetAllStackTraces(jvmtiStackInfo **pStackInfoArray, 
                                          jint *pThreadCount,
                                          jint maxFrameCount)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }
        virtual MPI::EThreadState VmThreadStateToMpiThreadState(jint vmThreadState)
        {
            return MPI::TS_UNKNOWN;
        }
        virtual TResult DeallocateVmBuffer(unsigned char *pBuffer)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }
        virtual TResult RunGC();
        virtual TResult IterateLiveHeap(IterHeapOps iterops)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }
        virtual bool CanRedefineClass(jclass cls)
        {
            return false;
        }
        virtual TResult CreateRawMonitor(const char *szName, CRawMonitor **pNewMonitor)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }
        virtual TResult RunAgentThread(jobject thread, 
                               TAgentThreadStartFunction proc, 
                               void *arg)
        {
            return MRTE_ERROR_NOT_SUPPORTED;
        }


    private:
        // private member functions
        void InitEventTranslationArrays();
        void InitEventsCallback();
        void InformAvailableEvents();

        //private member variables

        // interface to JVMTI
        JVMPI_Interface *m_pJVMPIInterface;

        // an array holding the translation from JVMPI events to MPI events
        MPI::TEventType m_vJVMPI2MpiEvents[JVMPI_MAX_EVENT_TYPE_VAL+1];

        // an array holding the translation from MPI events to JVMTI events
        jint m_vMpi2JVMPIEvents[Infrastructure::EM_EVENT_LAST];

        // pointer to event manager
        CEventManager *m_pEventManager;


};
}};

#endif // #define MRTE_JVMPI_INTERFACE_H
