/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef _MRTE_JPI_EVENT_H
#define _MRTE_JPI_EVENT_H

#include "MpiAPI.h"
#include "MRTEInfrastructureDefinitions.h"

//TODO: remove
//#define JPI_EVENT (MPI_EVENT + 1)

namespace Martini { namespace JPI
{
    /**
     * @brief A base class for defining JPI internal event observers
     *
     * A base class for defining internal JPI event observers
     * These observers are used by internal JPI modules. 
     * Events to internal observers are dispatched directly to their client without the need
     * to translate data or obtain additional information from Data Manager. Thus, they provide
     * a more efficient mechanism for internal modules which can directly manipulate the
     * "raw data" supplied with the event. Internal observers can also define an optional 
     * priority which tells the Event Manager whether to call this observer before or after 
     * regular observers.
     *
     * Internal observers are registered using the CEventManager::RegisterEventInternal 
     * function.
     */
    class IInternalEventObserver : public MPI::IEventObserver  
    {
    public:

        virtual MPI::BitSet EventDataTypes() { return MPI::DR_NONE; }

        /**
         * @brief Returns the observer's priority
         *
         * Returns the observer's priority. The priority is used by the Event Manager to 
         * determine the order in which observers are notified for an event.
         * High priority observers are notified before Normal.
         * Low priority observers are notified after Normal.
         * Observers with the same priority are notified according to registration order.
         */
        virtual Infrastructure::EEventPriority GetPriority() 
        {
            return Infrastructure::EVENT_PRIORITY_NORMAL;
        };

        /**
         * @brief Event handler
         *
         * Event handler for internal observers.
         *
         * @param[in] pEvent        event information
         * @param[in] pUserData     user-defined event data
         */
        virtual void HandleEvent(struct SEmData *pEvent, void *pUserData) = 0;    
    };
}}
#endif 
