/*****************************************************************************
 * Copyright (c) 1997, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#include "JpiGlobals.h"
#include "LogAssert.h"

using namespace Martini::JPI;
using namespace Martini::OSA;
using namespace Martini::Infrastructure;

//////////////////////////////////////////////////////////////////////////
// CJpiGlobals

CJpiGlobals* CJpiGlobals::m_pInstance = NULL;

const bool CJpiGlobals::SJpiThreadStatus::DEFAULT_MPI_SAFE_STATUS = true;

CJpiGlobals::CJpiGlobals()
    : pfnMethodEnterHandler(NULL), pfnMethodLeaveHandler(NULL), 
    pfnMethodLeaveWithExcetionHandler(NULL), pfnObjectAllocHandler(NULL),
    pfnArrayAllocHandler(NULL), pfnGetObjTIdHandler(NULL), pJvmInterface(NULL), bJvmInitDone(false),
    m_ptlsMpiThreadStatus(NULL), configFlags(MPI::CF_NONE), pConfigData(NULL)
{
    if (!m_ptlsMpiThreadStatus)
    {
        m_ptlsMpiThreadStatus = CreateThreadLocalStorage();
        if (!m_ptlsMpiThreadStatus)
        {
            MARTINI_ERROR("CJpiGlobals", "Error creating thread local storage");
        }
    }
}

