/*****************************************************************************
 * Copyright (c) 1997, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef _MRTE_JPI_GLOBALS_H
#define _MRTE_JPI_GLOBALS_H

#include <stdlib.h>

#include "CGAdaptor.h"
#include "HeapAdaptor.h"
#include "ThreadAdaptor.h"
#include "IJVM.h"
#include "DataManager.h"
#include "OSA.h"

namespace Martini { namespace JPI {

    /**
     * @brief Class for storing shared JPI information
     */
    class CJpiGlobals
    {
    public:
        struct SJpiThreadStatus
        {
            SJpiThreadStatus(bool mpiSafe) : IsMpiSafe(mpiSafe) {}

            static const bool DEFAULT_MPI_SAFE_STATUS;

            bool IsMpiSafe;
        };

        ~CJpiGlobals();
        
        /**
         * @return Returns the singleton instance
         */
        static CJpiGlobals* Instance() 
        {
            if (NULL == m_pInstance)
            {
                m_pInstance = new CJpiGlobals();
            }
            return m_pInstance;
        }

        /**
         * @brief Marks the status of the current thread as unsafe for certain MPI calls.
         *
         * Marks the status of the current (calling) thread as unsafe for certain MPI calls.
         * This will cause certain MPI functions to fail (see MpiAPI.h for more information).
         */
        void SetThreadMpiUnsafe()
        {
            SJpiThreadStatus *pStatus = (SJpiThreadStatus*)m_ptlsMpiThreadStatus->GetValue();
            if (pStatus)
            {
                pStatus->IsMpiSafe = false;
            }
            else
            {
                m_ptlsMpiThreadStatus->SetValue(new SJpiThreadStatus(false));
            }
        }

        /**
         * @brief Marks the status of the current thread as safe for all MPI calls.
         */
        void SetThreadMpiSafe()
        {
            SJpiThreadStatus *pStatus = (SJpiThreadStatus*)m_ptlsMpiThreadStatus->GetValue();
            if (pStatus)
            {
                pStatus->IsMpiSafe = true;
            }
            else
            {
                m_ptlsMpiThreadStatus->SetValue(new SJpiThreadStatus(true));
            }
        }

        /**
         * @return Returns whether the current thread is "MPI-safe" or not
         */
        bool IsThreadMpiSafe()
        {
            bool threadMpiStatus;
            SJpiThreadStatus *pStatus = (SJpiThreadStatus*)m_ptlsMpiThreadStatus->GetValue();
            if (pStatus)
            {
                threadMpiStatus = pStatus->IsMpiSafe;
            }
            else
            {
                threadMpiStatus = SJpiThreadStatus::DEFAULT_MPI_SAFE_STATUS;
            }
            return threadMpiStatus;
        }

        // Method enter and leave callbacks
        CGAdaptor::TMethodEnterHandler pfnMethodEnterHandler;
        CGAdaptor::TMethodLeaveHandler pfnMethodLeaveHandler;
        CGAdaptor::TMethodLeaveHandler pfnMethodLeaveWithExcetionHandler;

        // Object Alloc and Array Alloc callbacks
        HeapAdaptor::TObjectAllocHandler pfnObjectAllocHandler;
        HeapAdaptor::TArrayAllocHandler pfnArrayAllocHandler;

		// Heap Object Data callback for obtaining the TId given an Object.
        HeapAdaptor::TGetObjTIdHandler pfnGetObjTIdHandler;

        // Call for thread interaction method callbacks
        ThreadAdaptor::TThreadInteractionHandler pfnThreadInteractionHandler;


        // JVM Interface
        IJVM* pJvmInterface;

        // Data Manager
        CDataManager* pDataManager;

        // VM initialization status
        bool bJvmInitDone;

        // JPI Configuration flags (one or more MPI::EConfigurationFlags values)
        MPI::BitSet configFlags;

        // JPI Configuration data
        MPI::SConfigData* pConfigData;
        
    private:
        CJpiGlobals();
        
        static CJpiGlobals* m_pInstance;

        // A TLS entry for tracking thread-related status information
        OSA::IThreadLocalStorage* m_ptlsMpiThreadStatus;
    };
}}

#endif


