/*****************************************************************************
 * Copyright (c) 1997, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#include "MPIUtils.h"

void Martini::MPI::GetEventsInGroup(Martini::MPI::TEventTypeList *eventList, 
                                    Martini::MPI::EEventGroup group)
{
    TMRTEHandle h;
    switch (group)
    {
    case EG_CALL_GRAPH:
        h = eventList->GetLast();
        eventList->InsertAfter(h, EV_METHOD_ENTER);
        h = eventList->GetLast();
        eventList->InsertAfter(h, EV_METHOD_LEAVE);
        break;
        
    case EG_HEAP:
        h = eventList->GetLast();
        eventList->InsertAfter(h, EV_OBJECT_ALLOC);
        h = eventList->GetLast();
        eventList->InsertAfter(h, EV_OBJECT_FREE);
        break;
        
    case EG_MONITOR:
        h = eventList->GetLast();
        eventList->InsertAfter(h, EV_MONITOR_WAIT);
        h = eventList->GetLast();
        eventList->InsertAfter(h, EV_MONITOR_WAITED);
        h = eventList->GetLast();
        eventList->InsertAfter(h, EV_CONTENDED_MONITOR_ENTER);
        h = eventList->GetLast();
        eventList->InsertAfter(h, EV_CONTENDED_MONITOR_ENTERED);
        break;
    case EG_THREAD_INTERACTION:
        h = eventList->GetLast();
        eventList->InsertAfter(h,  EV_THREAD_INTERACTION);
        break;
    }
}

bool Martini::MPI::IsEventInGroup(Martini::MPI::TEventType event, 
                                  Martini::MPI::EEventGroup group)
{
    bool bResult = false;
    switch (group)
    {
    case EG_CALL_GRAPH:
        if (EV_METHOD_ENTER == event 
            || EV_METHOD_LEAVE == event)
        {
            bResult = true;
        }
        break;
        
    case EG_HEAP:
        if (EV_OBJECT_ALLOC == event
            || EV_OBJECT_FREE == event)
        {
            bResult = true;
        }
        break;
        
    case EG_MONITOR:
         if (EV_MONITOR_WAIT == event
            || EV_MONITOR_WAITED == event 
            || EV_CONTENDED_MONITOR_ENTER == event
            || EV_CONTENDED_MONITOR_ENTERED == event)
        {
            bResult = true;
        }
        break;
    case EG_THREAD_INTERACTION:
         if ( EV_THREAD_INTERACTION == event)
        {
            bResult = true;
        }
        break;
    }
    return bResult;
}

bool Martini::MPI::DoesGroupSupportFilter(Martini::MPI::EEventGroup group, 
                                          Martini::MPI::IEventFilter &filter)
{
    bool bResult = false;
    switch (group)
    {
    case EG_CALL_GRAPH:
        if (IEventFilter::FT_CALLGRAPH == filter.Type())
        {
            bResult = true;
        }
        break;
    case EG_HEAP:
        if (IEventFilter::FT_HEAP == filter.Type())
        {
            bResult = true;
        }
        break;
    case EG_THREAD_INTERACTION:
        if (IEventFilter:: FT_THREAD_INTERACTION == filter.Type())
        {
            bResult = true;
        }
        break;
    }
    return bResult;
}

Martini::MPI::EEventGroup Martini::MPI::GetEventGroup(Martini::MPI::TEventType event)
{
    EEventGroup group = EG_NONE;
    switch (event)
    {
    case EV_METHOD_ENTER:
    case EV_METHOD_LEAVE:
        group = EG_CALL_GRAPH;
        break;
        
    case EV_OBJECT_ALLOC:
    case EV_OBJECT_FREE:
        group = EG_HEAP;
        break;
        
    case EV_MONITOR_WAIT:
    case EV_MONITOR_WAITED:
    case EV_CONTENDED_MONITOR_ENTER:
    case EV_CONTENDED_MONITOR_ENTERED:
        group = EG_MONITOR;
        break;

    case EV_THREAD_INTERACTION:
        group = EG_THREAD_INTERACTION;
        break;
    }
    return group;
}
