/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/


#ifndef _MRTE_PROFILING_INTERFACE_ABSTRACTION_H
#define _MRTE_PROFILING_INTERFACE_ABSTRACTION_H

////////////////////////////////// JVMPI stuff ///////////////////////////
#include "jvmpi.h"

// JVMPI event callback type
typedef void (*TEmStdPICallback)(JVMPI_Event *);

// Internal modules events callback
typedef void (*TEmInternalStdCallback)(JVMPI_Event *, void *);

// JVMPI event type
typedef jint TEmStdEventType;

// JVMPI event data
typedef JVMPI_Event TEmStdEventData;

// JVMPI interface 
typedef JVMPI_Interface TStdJavaInterface;

// success indication
#define JAVA_STD_SUCCESS JVMPI_SUCCESS 

// max value of JVMPI events
// adding 1 so the event itself is the index to the array (max == GC_END == 61)
#define JAVA_STD_MAX_EVENTS (JVMPI_MAX_EVENT_TYPE_VAL+1) 

// JVMPI events
#define JAVA_STD_EVENT_THREAD_START             JVMPI_EVENT_THREAD_START
#define JAVA_STD_EVENT_THREAD_END               JVMPI_EVENT_THREAD_END
#define JAVA_STD_EVENT_COMPILED_METHOD_LOAD     JVMPI_EVENT_COMPILED_METHOD_LOAD
#define JAVA_STD_EVENT_COMPILED_METHOD_UNLOAD   JVMPI_EVENT_COMPILED_METHOD_UNLOAD
#define JAVA_STD_EVENT_CLASS_LOAD_HOOK          JVMPI_EVENT_CLASS_LOAD_HOOK
#define JAVA_STD_EVENT_CLASS_LOAD               JVMPI_EVENT_CLASS_LOAD
#define JAVA_STD_EVENT_CLASS_UNLOAD             JVMPI_EVENT_CLASS_UNLOAD
#define JAVA_STD_EVENT_JVM_INIT_DONE            JVMPI_EVENT_JVM_INIT_DONE
#define JAVA_STD_EVENT_JVM_SHUT_DOWN            JVMPI_EVENT_JVM_SHUT_DOWN
#define JAVA_STD_EVENT_OBJECT_ALLOC             JVMPI_EVENT_OBJECT_ALLOC
#define JAVA_STD_EVENT_OBJECT_FREE              JVMPI_EVENT_OBJECT_FREE
#define JAVA_STD_EVENT_OBJECT_MOVE              JVMPI_EVENT_OBJECT_MOVE
#define JAVA_STD_EVENT_GC_START                 JVMPI_EVENT_GC_START
#define JAVA_STD_EVENT_GC_FINISH                JVMPI_EVENT_GC_FINISH
#define JAVA_STD_EVENT_METHOD_ENTRY             JVMPI_EVENT_METHOD_ENTRY
#define JAVA_STD_EVENT_METHOD_LEAVE             JVMPI_EVENT_METHOD_EXIT
#define JAVA_STD_EVENT_INIT_DONE                JVMPI_EVENT_JVM_INIT_DONE
#define JAVA_STD_EVENT_JVM_SHUT_DOWN            JVMPI_EVENT_JVM_SHUT_DOWN
#define JAVA_STD_EVENT_ARENA_NEW                JVMPI_EVENT_ARENA_NEW
#define JAVA_STD_EVENT_ARENA_DELETE             JVMPI_EVENT_ARENA_DELETE

enum EJVMVendor
{
    JAVA_STD_VENDOR_UNKNOWN = 0,
    JAVA_STD_VENDOR_BEA = 1,
    JAVA_STD_VENDOR_IBM = 2,
    JAVA_STD_VENDOR_SUN = 3
};

#define MAX_STD_ARRAY_TYPES (JVMPI_LONG+1)


#endif // _MRTE_PROFILING_INTERFACE_ABSTRACTION_H






















