/*****************************************************************************
 * Copyright (c) 1997, 2009, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id: DirectoryHandle.cpp,v 1.1 2009/07/10 00:29:38 jwest Exp $ 
 *****************************************************************************/

#include "OSAA.h"

#define DIRECTORY_DOT       "."  
#define DIRECTORY_DOT_DOT   ".."  

using namespace Martini::OSA;

Martini::OSA::CDirectoryHandle::CDirectoryHandle()
{
    m_szDirectoryName = 0;
    m_hDirectory = 0;
}

Martini::OSA::CDirectoryHandle::~CDirectoryHandle()
{
}

TResult Martini::OSA::CDirectoryHandle::Open(const char *cszDirName)
{
    unsigned int uiDirNameLength;
    
    if (cszDirName == 0)
    {
        return MRTE_ERROR_ILLEGAL_ARGUMENT;
    }
    
    m_hDirectory = opendir(cszDirName);
    
    if (m_hDirectory == 0)
    {
        return MRTE_ERROR_INVALID_HANDLE;
    }
    // copy directory name
    uiDirNameLength = strlen(cszDirName);
    m_szDirectoryName = new char[uiDirNameLength + 1];
    if (m_szDirectoryName == 0)
    {
        return MRTE_ERROR_OUT_OF_MEMORY;
    }
    
    strcpy(m_szDirectoryName, cszDirName);
    
    return MRTE_RESULT_OK;
}

TResult Martini::OSA::CDirectoryHandle::GetNextFileName(bool* pbIsDirectory, char* szFileName, 
                                                               unsigned int uiNumOfBytesToWrite,
                                                               unsigned int *puiNumOfBytesNeeded)
{
    dirent currDirEntry, *pCurrDirEntry;
    unsigned int uiNeededSize;
    struct stat properties;
    char szEntryFullPath[MAX_PATH] = {'\0'};
    
    if (szFileName == 0)
    {
        return MRTE_ERROR_ILLEGAL_ARGUMENT;
    }
    
    // read next file details
    readdir_r(m_hDirectory, &currDirEntry, &pCurrDirEntry);
    
    // skip the file if it is "." or ".." - not interesting to the user
    while (pCurrDirEntry != 0 && (! strcmp(pCurrDirEntry->d_name, DIRECTORY_DOT) || 
        ! strcmp(pCurrDirEntry->d_name, DIRECTORY_DOT_DOT)))
    {
        readdir_r(m_hDirectory, &currDirEntry, &pCurrDirEntry);
    }
    
    
    if (pCurrDirEntry == 0)
    {// the next file was not found
        return MRTE_RESULT_END_OF_DATA;
    }
    
    // check if the buffer is big enough
    uiNeededSize = strlen(pCurrDirEntry->d_name) + 1;
    
    if (uiNeededSize > uiNumOfBytesToWrite)
    {
        return MRTE_ERROR_BUFFER_TOO_SHORT;
    }
    
    strcpy(szFileName, pCurrDirEntry->d_name);
    
    if (puiNumOfBytesNeeded)
    {
        *puiNumOfBytesNeeded = uiNeededSize;
    }
    
    // create the full path of the file for quering its properties -  
    // in particular,if this is directory or not
    
    strcat(szEntryFullPath, GetName());
    if (szEntryFullPath[strlen(GetName()) - 1] != '/')
    {
        strcat(szEntryFullPath, "/");
    }
    
    strcat(szEntryFullPath, szFileName);
    
    // get the file properties
    stat(szEntryFullPath, &properties);
    
    *pbIsDirectory = S_ISDIR(properties.st_mode);
    
    return MRTE_RESULT_OK;
}

const char* Martini::OSA::CDirectoryHandle::GetName()
{
    return m_szDirectoryName;
}

TResult Martini::OSA::CDirectoryHandle::Destroy()
{
    if (m_szDirectoryName)
    {
        delete m_szDirectoryName;
    }
    
    if (m_hDirectory != 0)
    {
        closedir(m_hDirectory);
    }
    
    delete this;
    return MRTE_RESULT_OK;
}


