/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#include <dlfcn.h>
#include "OSAL.h"


Martini::OSA::CLibraryLoader::CLibraryLoader()
{
}

Martini::OSA::CLibraryLoader::~CLibraryLoader()
{
}

void* Martini::OSA::CLibraryLoader::GetEntry(char *szEntryName)
{   
    return dlsym(m_vpLibrary, szEntryName);
}


TResult Martini::OSA::CLibraryLoader::Destroy()
{   
    delete this;
    return MRTE_RESULT_OK;
}

static void CheckIfLibraryIsLoaded(const char *szLibName, char *LibPathBuff);

TResult Martini::OSA::CLibraryLoader::Create(const char *szLibName, const char *szLibPath, bool bLoadOnce) 
{   
    char szLoadedDllFullPath[MAX_PATH], szLoadedLibPath[MAX_PATH];
    szLoadedDllFullPath[0] = 0;	
    
    if (szLibName == NULL)
    {
        return MRTE_ERROR_ILLEGAL_ARGUMENT;
    }
    if (bLoadOnce)
    {
        CheckIfLibraryIsLoaded(szLibName,szLoadedLibPath);
        if (!(strcmp(szLoadedLibPath,"Err")))
        {
                return MRTE_ERROR_ILLEGAL_ARGUMENT;
        }
        else if (!(strcmp(szLoadedLibPath,"NULL")))
        {
            bLoadOnce = false;
        }
        else
        {
            strcpy(szLoadedDllFullPath,szLoadedLibPath); 
        }
        
    }
    if (!bLoadOnce)
    {
        if ((szLibPath != NULL) && (szLibPath[0] != '\0')) 
        {
            strcat(szLoadedDllFullPath, szLibPath);
            strcat(szLoadedDllFullPath, "/");
        }
    
        strcat(szLoadedDllFullPath, "lib");
        strcat(szLoadedDllFullPath, szLibName);
        strcat(szLoadedDllFullPath, ".so");
    }

    m_vpLibrary = dlopen(szLoadedDllFullPath, RTLD_LAZY);
    if (m_vpLibrary == NULL) 
    {
    //    fprintf(stderr,"dll %s failed to load: %s\n",szLoadedDllFullPath,dlerror());
        return MRTE_ERROR_LIBRARY_FAILURE;
    }
//    fprintf(stderr,"dll %s loaded\n",szLoadedDllFullPath);
    return MRTE_RESULT_OK;
}


static void CheckIfLibraryIsLoaded(const char *szLibName, char *LibPathBuff)
{

    FILE *f;
    char linebuf[MAX_PATH];
    U64 st=0, en=0, len;
    int dunno, cu = 0, i, j=0, p_id;
    char flags[32], indev[32], path[MAX_PATH];
    char szTempLibName[MAX_PATH], FileName[MAX_PATH];


    p_id=getpid();
    sprintf(FileName,"/proc/%d",p_id);
    strcat(FileName,"/maps");
    if(!(f = fopen(FileName,"r"))) 
    {
         strcpy(LibPathBuff,"Err");
         return;
    }
    while(!feof(f)) 
    {
        if(!fgets(linebuf, sizeof linebuf, f))
        {
            break;
        }
        // only the path data is relevant. all the other vars (st, en, flags...) are for parsing.
        if(sscanf(linebuf, "%lx-%lx %s %8lx %s %ld %s\n", &st, &en, flags, &len, indev, &dunno, path) < 5) 
        {
            break;
        }
        cu++;
        i=strlen(path);
        while ((i>0) && (path[i]!='/'))
        {
            i--;
        }    
        i++;
        if ((path[i]=='l') && (path[i+1]=='i') && (path[i+2]=='b'))
        {
            i+=3;
        }
        while (!((path[i]=='.') && (path[i+1]=='s') && (path[i+2]=='o')) && (i < strlen(path)))
        {
            szTempLibName[j++]=path[i++];
        }
        szTempLibName[j]='\0';
        j=0;
        if (!strcmp(szLibName,szTempLibName))
        {
            strcpy(LibPathBuff,path);
            return ;
        }
    }
    strcpy(LibPathBuff,"NULL");
    return ;
            
}
