/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#include "OSAL.h"
#include <unistd.h>
#include <sys/mman.h>

using namespace Martini::OSA;

Martini::OSA::CReadOnlyFileMapping::CReadOnlyFileMapping()
{
    m_iFileDesc = INVALID_HANDLE_VALUE;
    m_pMappedFileBaseAddress = 0;
    m_uiLength = 0;   
}

Martini::OSA::CReadOnlyFileMapping::~CReadOnlyFileMapping()
{
}

TResult Martini::OSA::CReadOnlyFileMapping::Open(const char *szFileName)
{    
    if (szFileName == 0)
    {
        return MRTE_ERROR_ILLEGAL_ARGUMENT;
    }
    
    // open the file
    m_iFileDesc = open(szFileName, O_RDONLY);
    
    if (m_iFileDesc == INVALID_HANDLE_VALUE)
    {
        return MRTE_ERROR_INVALID_HANDLE;
    }
    
    m_uiLength = GetFileSize(m_iFileDesc);
    
    if (m_uiLength == INVALID_FILE_SIZE)
    {
        close(m_iFileDesc);
        return MRTE_ERROR_FILE_FAILURE;
    }
    
    // create mapping of the whole file
    m_pMappedFileBaseAddress = mmap(0, m_uiLength, PROT_READ, MAP_PRIVATE, m_iFileDesc, 0);
    
    if (m_pMappedFileBaseAddress ==(void*) -1)
    {
        m_pMappedFileBaseAddress = 0;
    }
    
    if (!m_pMappedFileBaseAddress)
    {
        close(m_iFileDesc);
        return MRTE_RESULT_FALSE;
    }
    
    return MRTE_RESULT_OK;
}

unsigned int Martini::OSA::CReadOnlyFileMapping::GetFileSize(int iFileDesc)
{
    struct stat file_status;
    
    // get file statistics
    fstat(iFileDesc, &file_status);
    return file_status.st_size;
}

TResult Martini::OSA::CReadOnlyFileMapping::Destroy()
{
    if (m_pMappedFileBaseAddress)
    {
        munmap(m_pMappedFileBaseAddress, m_uiLength);
    }
    
    if (m_iFileDesc != INVALID_HANDLE_VALUE)
    {
        close(m_iFileDesc);
    }
    
    delete this;
    return MRTE_RESULT_OK;
}


