/*****************************************************************************
 * Copyright (c) 2009, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id: ThreadSync.cpp,v 1.1 2009/04/14 20:33:46 jwest Exp $
 *****************************************************************************/

#include "OSAL.h"

#define PTHREAD_MUTEX_RECURSIVE_NP PTHREAD_MUTEX_RECURSIVE

Martini::OSA::CThreadSync::CThreadSync()
{
}

Martini::OSA::CThreadSync::~CThreadSync()
{
    pthread_mutex_destroy(&m_pthreadSync);
}


TResult Martini::OSA::CThreadSync::Enter()
{
    pthread_mutex_lock(&m_pthreadSync);
    return MRTE_RESULT_OK;
}

TResult Martini::OSA::CThreadSync::Leave()
{
    pthread_mutex_unlock(&m_pthreadSync);
    return MRTE_RESULT_OK;
}

TResult Martini::OSA::CThreadSync::TryEnter()
{
    int iLocked = pthread_mutex_trylock(&m_pthreadSync);
    if (iLocked == 0)
    {
        return MRTE_RESULT_FALSE;
    }
    return MRTE_RESULT_OK;
}

TResult Martini::OSA::CThreadSync::Destroy()
{
    delete this;
    return MRTE_RESULT_OK;
}

TResult Martini::OSA::CThreadSync::Create()
{
    pthread_mutexattr_t attr;

    pthread_mutexattr_init(&attr);
    pthread_mutexattr_settype( &attr, PTHREAD_MUTEX_RECURSIVE_NP );
    pthread_mutex_init(&m_pthreadSync, &attr);	// always returns 0

    return MRTE_RESULT_OK;
}

