/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifdef EM64T_ARCH
#pragma runtime_checks( "", off )
#endif


#include "OSAW.h"

using namespace Martini::OSA;

#define DIRECTORY_DOT       "."  
#define DIRECTORY_DOT_DOT   ".."  

CDirectoryHandle::CDirectoryHandle()
{
    m_szDirectoryName       = 0;
    m_hDirectory            = INVALID_HANDLE_VALUE;
    m_hDirectorySearch      = INVALID_HANDLE_VALUE;
}

TResult CDirectoryHandle::Open(const char *cszDirName)
{
    WIN32_FIND_DATA data;
    size_t uiDirNameLength;

    if(cszDirName == 0)
    {
        return MRTE_ERROR_ILLEGAL_ARGUMENT;
    }

    m_hDirectory = CreateFile(cszDirName, GENERIC_READ, FILE_SHARE_READ, 0, OPEN_EXISTING,
        FILE_ATTRIBUTE_READONLY | FILE_FLAG_BACKUP_SEMANTICS , 0);
    
    if (m_hDirectory == INVALID_HANDLE_VALUE)
    {
        return MRTE_ERROR_INVALID_HANDLE;
    }
    
    // copy directory name
    uiDirNameLength = strlen(cszDirName);
    m_szDirectoryName = new char[uiDirNameLength + 3];
    if(m_szDirectoryName == 0)
    {
        return MRTE_ERROR_OUT_OF_MEMORY;
    }
    
    strcpy(m_szDirectoryName, cszDirName);

    // append '\' if directory name does not end with it
    if(m_szDirectoryName[uiDirNameLength - 1] != '\\')
    {
        strcat(m_szDirectoryName, "\\");
        uiDirNameLength++;
    }
    
    // add '*' to mark that the iteration is on all files in the directory
    strcat(m_szDirectoryName, "*");
    
    // create the directory iterator
    m_hDirectorySearch = FindFirstFile(m_szDirectoryName, &data);
    
    // remove '*' so that user-friendly name is saved
    m_szDirectoryName[uiDirNameLength] = '\0';

    if (m_hDirectorySearch == INVALID_HANDLE_VALUE)
    {
        return MRTE_ERROR_INVALID_HANDLE;
    }

    return MRTE_RESULT_OK;
}

TResult CDirectoryHandle::GetNextFileName(bool* pbIsDirectory, char* szFileName, 
                                            unsigned int uiNumOfBytesToWrite,
                                            unsigned int *puiNumOfBytesNeeded)
{
    WIN32_FIND_DATA data;
    bool bRetVal;
    size_t uiNeededSize;

    
    if(szFileName == 0)
    {
        return MRTE_ERROR_ILLEGAL_ARGUMENT;
    }
    
    // get next file details, bRetVal is 'true' when the next file details were found
    bRetVal = (FindNextFile(m_hDirectorySearch, &data) == TRUE);

    // skip the file if it is "." or ".." - not interesting to the user
    while(bRetVal && (!strcmp(data.cFileName, DIRECTORY_DOT) || 
                      !strcmp(data.cFileName, DIRECTORY_DOT_DOT)))
    {
        bRetVal = (FindNextFile(m_hDirectorySearch, &data) == TRUE);
    }
    
    if(bRetVal == false)
    {// the next file was not found
        return MRTE_RESULT_END_OF_DATA;
    }

    // check if the file is a directory
    if(pbIsDirectory != 0)
    {
       *pbIsDirectory = ((data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0);
    }
    
    uiNeededSize = strlen(data.cFileName) + 1;

    if(uiNeededSize > uiNumOfBytesToWrite)
    {
        return MRTE_ERROR_BUFFER_TOO_SHORT;
    }
    
    strcpy(szFileName, data.cFileName);

    if(puiNumOfBytesNeeded)
    {
        *puiNumOfBytesNeeded = (unsigned int) uiNeededSize;
    }

    return MRTE_RESULT_OK;
}

const char* CDirectoryHandle::GetName()
{
    return m_szDirectoryName;
}

TResult CDirectoryHandle::Destroy()
{
    if(m_szDirectoryName)
    {
        delete m_szDirectoryName;
    }
    
    if (m_hDirectorySearch != INVALID_HANDLE_VALUE)
    {
        // close the iterator
        FindClose(m_hDirectorySearch);
    }
    if (m_hDirectory != INVALID_HANDLE_VALUE)
    {
        // close the directory handle
        CloseHandle(m_hDirectory);
    }

    delete this;
    return MRTE_RESULT_OK;
}

CDirectoryHandle::~CDirectoryHandle()
{
}
