/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifdef EM64T_ARCH
#pragma runtime_checks( "", off )
#endif

#include "OSAW.h"


Martini::OSA::CLibraryLoader::CLibraryLoader()
{
}

Martini::OSA::CLibraryLoader::~CLibraryLoader()
{
}

void* Martini::OSA::CLibraryLoader::GetEntry(char *szEntryName)
{   
    return GetProcAddress(m_module, szEntryName);
}

TResult Martini::OSA::CLibraryLoader::Destroy()
{   
    delete this;
    return MRTE_RESULT_OK;
}


TResult Martini::OSA::CLibraryLoader::Create(const char *szLibName, 
                                                    const char *szLibPath, bool bLoadOnce) 
{   
    char szLoadedDllFullPath[MAX_PATH];
    szLoadedDllFullPath[0] = 0;	
    
    if (bLoadOnce)
    {
        m_module = GetModuleHandle(szLibName);
        if (m_module)
        {
            return MRTE_RESULT_OK;
        }
    }
    if ((szLibPath != NULL) && (szLibPath[0] != '\0')) 
    {
        lstrcat(szLoadedDllFullPath, szLibPath);
        lstrcat(szLoadedDllFullPath, "\\");
    }
    if (szLibName == NULL)
    {
        return MRTE_ERROR_ILLEGAL_ARGUMENT;
    }
    lstrcat(szLoadedDllFullPath, szLibName);
    lstrcat(szLoadedDllFullPath, ".dll");
    m_module = ::LoadLibraryEx(szLoadedDllFullPath, NULL, 
        LOAD_WITH_ALTERED_SEARCH_PATH);
    if (m_module == NULL) 
    {
        return MRTE_ERROR_LIBRARY_FAILURE;
    }
    return MRTE_RESULT_OK;
}

