/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifdef EM64T_ARCH
#pragma runtime_checks( "", off )
#endif


#include "OSAW.h"


namespace Martini { namespace OSA
{
    IThreadSync *CreateThreadSync()
    {
        CThreadSync* pThreadSync = new CThreadSync;
        if (!pThreadSync)
        {
            return NULL;
        }
        
        TResult res = pThreadSync->Create();
        if (MRTE_FAILED(res))
        {
            pThreadSync->Destroy();
            return NULL;
        }
        
        return pThreadSync;
    }
    
    
    ILibraryLoader *CreateLibraryLoader(const char *szLibName, const char *szLibPath, 
        bool bLoadOnce)
    {
        CLibraryLoader *pLibraryLoader = new CLibraryLoader();
        if (!pLibraryLoader)
        {
            return NULL;
        }
        
        TResult res = pLibraryLoader->Create(szLibName, szLibPath, bLoadOnce);
        if (MRTE_FAILED(res))
        {
            pLibraryLoader->Destroy();
            return NULL;
        }
        
        return pLibraryLoader;
    }
    
    IReadOnlyFileMapping *CreateReadOnlyFileMapping(const char *szFileName)
    {
        CReadOnlyFileMapping *pROFileMapping = new CReadOnlyFileMapping();
        TResult retVal;
        
        if (! pROFileMapping)
        {
            return NULL;
        }
        
        retVal = pROFileMapping->Open(szFileName);
        
        if (MRTE_FAILED(retVal))
        {
            pROFileMapping->Destroy();
            return NULL;
        }
        return pROFileMapping;
    }
    
    IDirectoryHandle *CreateDirectoryHandle(const char* szDirectoryName)		
    {
        CDirectoryHandle *pDirectory = new CDirectoryHandle();
        TResult retVal;
        
        if (! pDirectory)
        {
            return NULL;
        }
        
        retVal = pDirectory->Open(szDirectoryName);
        
        if (MRTE_FAILED(retVal))
        {
            pDirectory->Destroy();
            return NULL;
        }
        return pDirectory;
    }
    
    IThreadLocalStorage *CreateThreadLocalStorage()		
    {
        CThreadLocalStorage *pTls = new CThreadLocalStorage();
        TResult retVal;
        
        if (! pTls)
        {
            return NULL;
        }
        
        retVal = pTls->Create();
        
        if (MRTE_FAILED(retVal))
        {
            pTls->Destroy();
            return NULL;
        }
        return pTls;
    }
    
#ifdef IPF_ARCH
    
    extern "C" U64 rdtscll();
    
    U64 GetTimeStamp()
    {
        return rdtscll();
    }
    
#else // #ifdef IPF_ARCH
#ifdef EM64T_ARCH
    U64 GetTimeStamp()
    {
        return __rdtsc();
    }
#else // EM64T_ARCH
    
    U64 GetTimeStamp()
    {
        int lowTime, highTime;
        __asm 
        {
            // save regs
            push eax
                push edx
                
                // get current time
                rdtsc
                mov lowTime, eax
                mov highTime, edx
                
                // restore regs
                pop edx
                pop eax
        }      
        
        U64 tmpLow, tmpHigh;
        tmpLow = lowTime & 0xFFFFFFFF;
        tmpHigh = highTime & 0xFFFFFFFF;
        return ((tmpHigh << 32) | tmpLow);
    }
    
#endif // EM64T_ARCH
#endif // #ifdef IPF_ARCH
    
    TResult GetEnvironmentVar(char *szVarName, char *szValueBuffer, 
        unsigned int uiBufferSize, unsigned int *puiBufferSize)
    {
        if (szVarName == NULL || szValueBuffer == NULL || puiBufferSize== NULL)
        {
            return MRTE_ERROR_ILLEGAL_ARGUMENT;
        }
        unsigned int  uiLength = GetEnvironmentVariable(szVarName, szValueBuffer, 
            uiBufferSize);

        *puiBufferSize = uiLength + 1;

        if (uiLength == 0)
        {
            return MRTE_RESULT_FALSE;
        }
        if (uiLength > uiBufferSize)
        {
            return MRTE_ERROR_BUFFER_TOO_SHORT;
        }
        
        return MRTE_RESULT_OK;
    }
    
    
    TResult SetEnvironmentVar(char *szVarName, char *szValue)
    {
        BOOL bRes = SetEnvironmentVariable((LPCTSTR)szVarName, (LPCTSTR)szValue);
        if (bRes == FALSE)
        {
            return MRTE_ERROR_ILLEGAL_ARGUMENT;
        }
        return MRTE_RESULT_OK;
    }
    
    TResult MakeDirectory(char *szDirPath) // add and optional flag for security
    {
        if (CreateDirectory(szDirPath, NULL))
        {
            return MRTE_RESULT_OK;
        }
        else return MRTE_ERROR_OSA_FAILURE;
    }
    
    TResult GetExecutableFileName(char* szBuffer, unsigned int uiBufferSize,
        unsigned int *puiRequiredBufferSize)
    {
        if(szBuffer == 0)
        {
            return MRTE_ERROR_ILLEGAL_ARGUMENT;
        }
        char szLocalBuff[MAX_PATH];
        szLocalBuff[0] = '\0';
        
        DWORD dwStatus = GetModuleFileName(GetModuleHandle(NULL), szLocalBuff, uiBufferSize);
        DWORD dwNameLength = (DWORD)strlen(szLocalBuff) + 1;
        
        if(puiRequiredBufferSize)
        {
            *puiRequiredBufferSize = dwNameLength;
        }
        
        if(dwStatus && dwNameLength <= uiBufferSize)
        {
            strcpy(szBuffer, szLocalBuff);
            return MRTE_RESULT_OK;
        }
        else if(dwNameLength > uiBufferSize)
        {
            return MRTE_ERROR_BUFFER_TOO_SHORT;
        }
        else return MRTE_ERROR_OSA_FAILURE;
    }

    unsigned int GetCurrProcessID()
    {
        return (unsigned int)GetCurrentProcessId();
    }

    unsigned int GetCurrThreadID()
    {
        return (unsigned int)GetCurrentThreadId();
    }

    TResult GetCurrentProcCommandLine(char* szBuffer, unsigned int uiBufferSize,
        unsigned int *puiRequiredBufferSize)
    {
        LPTSTR pCommand = GetCommandLine();
        if (!pCommand)
        {
            MRTE_ERROR_OSA_FAILURE;
        }

        size_t len = strlen(pCommand);
        if (puiRequiredBufferSize)
        {
            *puiRequiredBufferSize = len + 1;
        }

        if (uiBufferSize < len + 1)
        {
            return MRTE_ERROR_BUFFER_TOO_SHORT;
        }

        strcpy(szBuffer, pCommand);
        
        return MRTE_RESULT_OK;
    }
    
    TResult GetThisMachineName(char* szBuffer, unsigned int uiBufferSize,
        unsigned int *puiRequiredBufferSize)
    {
        if (!puiRequiredBufferSize)
        {
            return MRTE_ERROR_ILLEGAL_ARGUMENT;
        }

//        This code did not return the correct value in puiRequiredBufferSize
//        *puiRequiredBufferSize = uiBufferSize;
//        BOOL bSuccess = GetComputerName(szBuffer, (LPDWORD)puiRequiredBufferSize);
//        if (!bSuccess)
//        {
//            if (GetLastError() == ERROR_BUFFER_OVERFLOW)
//            {
//                return MRTE_ERROR_BUFFER_TOO_SHORT;
//            }
//            else
//            {
//                return MRTE_ERROR_OSA_FAILURE;
//            }
//        }

        DWORD dwLen = MAX_COMPUTERNAME_LENGTH + 1;
        char szComputerName[MAX_COMPUTERNAME_LENGTH + 1];
        BOOL bSuccess = GetComputerName(szComputerName, &dwLen);
        if (!bSuccess)
        {
            return MRTE_ERROR_OSA_FAILURE;
        }

        *puiRequiredBufferSize = dwLen + 1;

        if (uiBufferSize < dwLen + 1)
        {
            return MRTE_ERROR_BUFFER_TOO_SHORT;
        }

        strcpy(szBuffer, szComputerName);

        return MRTE_RESULT_OK;
    }

    void Sleep(unsigned int uiMilliseconds)
    {
        ::Sleep(uiMilliseconds);
    }


}} // namespace
        
