/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//

#ifndef __OSAW32_H__
#define __OSAW32_H__

#include <windows.h>

#include "OSA.h"


namespace Martini { namespace OSA
{			
    class CReadOnlyFileMapping : public IReadOnlyFileMapping  
    {
    public:
        
        virtual void* GetBaseAddress() {return m_pMappedFileBaseAddress;};
        virtual unsigned int GetLength() {return m_uiLength;};
        
        virtual TResult Destroy();
    protected:
        // performs file mapping
        virtual TResult Open(const char *szFileName);
    protected:
        CReadOnlyFileMapping();
        virtual ~CReadOnlyFileMapping();
        
        // handle to the mapped file
        HANDLE          m_hFile;
        // handle to the file mapping object
        HANDLE          m_hFileMapping;
        // the address in virtual memory where the mapping beggins
        void*           m_pMappedFileBaseAddress;
        // the length of the mapped file
        unsigned int    m_uiLength;
        
        friend OSA_EXPORT IReadOnlyFileMapping *CreateReadOnlyFileMapping(const char *szFileName);
    };
    
    class CDirectoryHandle : IDirectoryHandle
    {
    public:
        virtual TResult GetNextFileName(bool* pbIsDirectory, char* szFileName, 
            unsigned int uiNumOfBytesToWrite,
            unsigned int *puiNumOfBytesNeeded);
        
        virtual const char* GetName();
        
        virtual TResult Destroy();
    protected:
        CDirectoryHandle();
        virtual ~CDirectoryHandle();
        
        // opens directory and creates directory iterator
        virtual TResult Open(const char *cszDirectoryName);
        
        friend OSA_EXPORT IDirectoryHandle *CreateDirectoryHandle(const char *cszDirName);
        
        // handle to directory
        HANDLE m_hDirectory;
        // handle to directory iterator
        HANDLE m_hDirectorySearch;
        char*  m_szDirectoryName;
    };
    
    class CLibraryLoader : public ILibraryLoader
    {
    public:
        virtual void *GetEntry(char *szEntryName);
        
        virtual TResult Destroy();
        
    protected:
        CLibraryLoader();
        virtual ~CLibraryLoader();
        virtual TResult Create(const char *szLibName, const char *szLibPath, 
            bool bLoadOnce = false);
        HMODULE m_module;
        
        friend OSA_EXPORT ILibraryLoader *CreateLibraryLoader(const char *szLibName, 
            const char *szLibPath, bool bLoadOnce);
        
    };	
    
    class CThreadSync : public IThreadSync  
    {
    public:
        virtual TResult Enter();
        virtual TResult Leave();
        virtual TResult TryEnter();
        
        virtual TResult Destroy();
    protected:
        CThreadSync();
        virtual ~CThreadSync();
        
        virtual TResult Create();
    protected:
        CRITICAL_SECTION m_csSync;
        
        friend OSA_EXPORT IThreadSync *CreateThreadSync();
    };			
    
    class CThreadLocalStorage : public IThreadLocalStorage
    {
        virtual void* GetValue();
        
        virtual void SetValue(void* pValue);
        
        virtual TResult Destroy();
    protected:
        CThreadLocalStorage();
        virtual ~CThreadLocalStorage();
        
        virtual TResult Create();
    protected:
        DWORD m_dwTlsIndex;
        
        friend OSA_EXPORT IThreadLocalStorage *CreateThreadLocalStorage();
    };

    
}} // namespace 
#endif     
        
